/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.debug;

import com.caucho.db.block.Block;
import com.caucho.db.block.BlockStore;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.Vfs;
import com.caucho.vfs.WriteStream;
import java.io.IOException;

public class DebugStore {
    Path _path;
    BlockStore _store;

    public DebugStore(Path path) throws Exception {
        this._path = path;
        this._store = BlockStore.createNoMmap(path);
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            System.out.println("usage: DebugStore store.db");
            return;
        }
        Path path = Vfs.lookup(args[0]);
        WriteStream out = Vfs.openWrite(System.out);
        new DebugStore(path).test(out);
        out.close();
    }

    public void test(WriteStream out) throws Exception {
        out.println("file-size   : " + this._store.getFileSize());
        out.println("block-count : " + this._store.getBlockCount());
        this.debugAllocation(out, this._store.getAllocationTable(), this._store.getBlockCount());
        this.debugFragments(out, this._store.getAllocationTable(), this._store.getBlockCount());
    }

    private void debugAllocation(WriteStream out, byte[] allocTable, long count) throws IOException {
        out.println();
        StringBuilder sb = new StringBuilder();
        int lastData = 0;
        int i = 0;
        while ((long)i < count) {
            byte v = allocTable[2 * i];
            int code = v & 0xF;
            switch (code) {
                case 0: {
                    sb.append('.');
                    break;
                }
                case 1: {
                    sb.append('r');
                    break;
                }
                case 2: {
                    sb.append('+');
                    break;
                }
                case 3: {
                    sb.append('p');
                    break;
                }
                case 5: {
                    sb.append('f');
                    break;
                }
                case 4: {
                    sb.append('i');
                    break;
                }
                default: {
                    sb.append('?');
                }
            }
            if (code != 0) {
                lastData = sb.length();
            }
            if (i % 64 == 63) {
                sb.append("\n");
            } else if (i % 8 == 7) {
                sb.append(' ');
            }
            ++i;
        }
        sb.setLength(lastData);
        out.println(sb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void debugFragments(WriteStream out, byte[] allocTable, long count) throws Exception {
        int totalUsed = 0;
        StringBuilder sb = new StringBuilder();
        boolean lastData = false;
        int len = 0;
        int i = 0;
        while ((long)i < count) {
            byte v = allocTable[2 * i];
            int code = v & 0xF;
            if (code == 5) {
                Object var17_15;
                Block block = this._store.readBlock(i * 8192);
                try {
                    block.read();
                    byte[] buffer = block.getBuffer();
                    for (int j = 0; j < 4; ++j) {
                        int mask = buffer[j + 7936] & 0xFF;
                        sb.append(this.bits(mask >> 4));
                        sb.append(this.bits(mask));
                        if (++len % 32 == 0) {
                            sb.append("\n");
                            continue;
                        }
                        if (len % 4 != 0) continue;
                        sb.append(" ");
                    }
                    var17_15 = null;
                    block.free();
                }
                catch (Throwable throwable) {
                    var17_15 = null;
                    block.free();
                    throw throwable;
                }
            }
            ++i;
        }
        if (sb.length() > 0) {
            out.println();
            out.println("Fragments:");
            out.println(sb);
        }
        out.println();
        out.println("Total-used: " + totalUsed);
    }

    private char bits(int b) {
        if ((b &= 0xF) == 0) {
            return '.';
        }
        if (b == 15) {
            return '+';
        }
        if (b < 10) {
            return (char)(b + 48);
        }
        return (char)(b + 97 - 10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readBlock(byte[] block, long count) throws Exception {
        ReadStream is = this._path.openRead();
        try {
            is.skip(count * 8192L);
            is.read(block, 0, block.length);
            Object var6_4 = null;
            is.close();
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            is.close();
            throw throwable;
        }
    }

    private int readShort(byte[] block, int offset) {
        return ((block[offset] & 0xFF) << 8) + (block[offset + 1] & 0xFF);
    }

    public void close() {
        this._store.close();
    }
}

