/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.fun;

import com.caucho.db.sql.Expr;
import com.caucho.db.sql.FromItem;
import com.caucho.db.sql.FunExpr;
import com.caucho.db.sql.Query;
import com.caucho.db.sql.QueryContext;
import com.caucho.util.L10N;
import java.sql.SQLException;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BitandExpr
extends FunExpr {
    protected static final L10N L = new L10N(BitandExpr.class);
    private Expr _left;
    private Expr _right;

    public BitandExpr() {
    }

    public BitandExpr(Expr left, Expr right) {
        this._left = left;
        this._right = right;
    }

    @Override
    protected void addArg(Expr expr) throws SQLException {
        if (this._left == null) {
            this._left = expr;
        } else if (this._right == null) {
            this._right = expr;
        } else {
            throw new SQLException(L.l("bitand() has too many arguments"));
        }
    }

    @Override
    public Class<?> getType() {
        return Long.TYPE;
    }

    @Override
    public Expr bind(Query query) throws SQLException {
        Expr newLeft = this._left.bind(query);
        Expr newRight = this._right.bind(query);
        return new BitandExpr(newLeft, newRight);
    }

    @Override
    public long subCost(ArrayList<FromItem> fromList) {
        return this._left.subCost(fromList) + this._right.subCost(fromList);
    }

    @Override
    public boolean isNull(QueryContext context) throws SQLException {
        return false;
    }

    @Override
    public double evalDouble(QueryContext context) throws SQLException {
        return this.evalLong(context);
    }

    @Override
    public long evalLong(QueryContext context) throws SQLException {
        return this._left.evalLong(context) & this._right.evalLong(context);
    }

    @Override
    public String evalString(QueryContext context) throws SQLException {
        return String.valueOf(this.evalLong(context));
    }

    public String toString() {
        return "bitand(" + this._left + ", " + this._right + ")";
    }
}

