/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.sql;

import com.caucho.db.sql.Expr;
import com.caucho.db.sql.FromItem;
import com.caucho.db.sql.Query;
import com.caucho.db.sql.QueryContext;
import java.sql.SQLException;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractBinaryExpr
extends Expr {
    AbstractBinaryExpr() {
    }

    protected abstract Expr getLeft();

    protected abstract Expr getRight();

    protected Expr create(Expr left, Expr right) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public boolean isNullable() {
        return this.getLeft().isNullable() || this.getRight().isNullable();
    }

    @Override
    public long subCost(ArrayList<FromItem> fromList) {
        return this.getLeft().subCost(fromList) + this.getRight().subCost(fromList);
    }

    @Override
    public Expr bind(Query query) throws SQLException {
        Expr left = this.getLeft();
        Expr right = this.getRight();
        Expr newLeft = left.bind(query);
        Expr newRight = right.bind(query);
        if (left == newLeft && right == newRight) {
            return this;
        }
        return this.create(newLeft, newRight);
    }

    @Override
    public void evalGroup(QueryContext context) throws SQLException {
        this.getLeft().evalGroup(context);
        this.getRight().evalGroup(context);
    }
}

