/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.sql;

import com.caucho.db.sql.Expr;
import com.caucho.db.sql.FromItem;
import com.caucho.db.sql.IdExpr;
import com.caucho.db.sql.Query;
import com.caucho.db.sql.QueryContext;
import com.caucho.db.sql.SelectResult;
import com.caucho.db.table.Column;
import com.caucho.db.table.Table;
import com.caucho.db.table.TableIterator;
import com.caucho.util.L10N;
import java.sql.SQLException;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractIdExpr
extends Expr {
    private static final L10N L = new L10N(IdExpr.class);

    AbstractIdExpr() {
    }

    protected abstract FromItem getFromItem();

    protected abstract Column getColumn();

    protected abstract int getTableIndex();

    public Class getType() {
        return this.getColumn().getJavaType();
    }

    @Override
    public String getName() {
        return this.getColumn().getName();
    }

    @Override
    public Table getTable() {
        return this.getFromItem().getTable();
    }

    @Override
    public boolean isNullable() {
        return !this.getColumn().isNotNull();
    }

    protected long lookupCost(ArrayList<FromItem> fromList) {
        FromItem fromItem = this.getFromItem();
        if (!fromList.contains(fromItem)) {
            return Integer.MAX_VALUE;
        }
        if (fromList.indexOf(fromItem) < fromList.size() - 1) {
            return 0L;
        }
        Column column = this.getColumn();
        if (column.isPrimaryKey()) {
            return 100L;
        }
        if (column.isUnique()) {
            return 10000L;
        }
        return 1000000L;
    }

    @Override
    public long subCost(ArrayList<FromItem> fromList) {
        if (!fromList.contains(this.getFromItem())) {
            return Integer.MAX_VALUE;
        }
        return 10000000L;
    }

    @Override
    public Expr bind(Query query) throws SQLException {
        return this;
    }

    @Override
    public boolean isNull(QueryContext context) throws SQLException {
        TableIterator[] rows = context.getTableIterators();
        TableIterator row = rows[this.getTableIndex()];
        return row.isNull(this.getColumn());
    }

    @Override
    public String evalString(QueryContext context) throws SQLException {
        TableIterator[] rows = context.getTableIterators();
        TableIterator row = rows[this.getTableIndex()];
        return row.getString(this.getColumn());
    }

    @Override
    public int evalBoolean(QueryContext context) throws SQLException {
        TableIterator[] rows = context.getTableIterators();
        TableIterator row = rows[this.getTableIndex()];
        String value = row.getString(this.getColumn());
        if (value == null) {
            return -1;
        }
        if (value.equals("1")) {
            return 1;
        }
        if (value.equalsIgnoreCase("t")) {
            return 1;
        }
        if (value.equalsIgnoreCase("y")) {
            return 1;
        }
        return 0;
    }

    public int evalInt(QueryContext context) throws SQLException {
        TableIterator[] rows = context.getTableIterators();
        TableIterator row = rows[this.getTableIndex()];
        return row.getInteger(this.getColumn());
    }

    @Override
    public long evalLong(QueryContext context) throws SQLException {
        TableIterator[] rows = context.getTableIterators();
        TableIterator row = rows[this.getTableIndex()];
        return row.getLong(this.getColumn());
    }

    @Override
    public double evalDouble(QueryContext context) throws SQLException {
        TableIterator[] rows = context.getTableIterators();
        TableIterator row = rows[this.getTableIndex()];
        return row.getDouble(this.getColumn());
    }

    @Override
    public void evalToResult(QueryContext context, SelectResult result) throws SQLException {
        TableIterator[] rows = context.getTableIterators();
        TableIterator row = rows[this.getTableIndex()];
        row.evalToResult(this.getColumn(), result);
    }

    @Override
    public int evalToBuffer(QueryContext context, byte[] buffer, int offset) throws SQLException {
        TableIterator[] rows = context.getTableIterators();
        TableIterator row = rows[this.getTableIndex()];
        return row.getBuffer(this.getColumn(), buffer, offset);
    }

    @Override
    public boolean evalEqual(QueryContext context, byte[] matchBuffer) throws SQLException {
        TableIterator[] rows = context.getTableIterators();
        TableIterator row = rows[this.getTableIndex()];
        return row.isEqual(this.getColumn(), matchBuffer);
    }

    @Override
    public boolean evalEqual(QueryContext context, String string) throws SQLException {
        TableIterator[] rows = context.getTableIterators();
        TableIterator row = rows[this.getTableIndex()];
        return row.isEqual(this.getColumn(), string);
    }

    public boolean equals(Object o) {
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        AbstractIdExpr expr = (AbstractIdExpr)o;
        return this.getFromItem() == expr.getFromItem() && this.getColumn() == expr.getColumn();
    }

    public String toString() {
        return this.getFromItem().getName() + "." + this.getColumn().getName();
    }
}

