/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.sql;

import com.caucho.db.sql.BinaryColumnEqExpr;
import com.caucho.db.sql.ColumnExpr;
import com.caucho.db.sql.DoubleEqExpr;
import com.caucho.db.sql.Expr;
import com.caucho.db.sql.FromItem;
import com.caucho.db.sql.IdExpr;
import com.caucho.db.sql.IdentityIndexExpr;
import com.caucho.db.sql.IndexExpr;
import com.caucho.db.sql.LongEqExpr;
import com.caucho.db.sql.OidExpr;
import com.caucho.db.sql.OidIndexExpr;
import com.caucho.db.sql.Query;
import com.caucho.db.sql.QueryContext;
import com.caucho.db.sql.RowIterateExpr;
import com.caucho.db.sql.StringEqExpr;
import com.caucho.db.sql.UnboundIdentifierExpr;
import com.caucho.db.table.Column;
import com.caucho.inject.Module;
import java.sql.SQLException;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Module
final class EqExpr
extends Expr {
    private final Expr _left;
    private final Expr _right;

    EqExpr(Expr left, Expr right) {
        if (left == null || right == null) {
            throw new NullPointerException();
        }
        if (right instanceof UnboundIdentifierExpr && !(left instanceof UnboundIdentifierExpr)) {
            Expr temp = right;
            right = left;
            left = temp;
        }
        this._left = left;
        this._right = right;
    }

    @Override
    public Expr bind(Query query) throws SQLException {
        Expr newLeft = this._left.bind(query);
        Expr newRight = this._right.bind(query);
        if (newLeft instanceof ColumnExpr && newLeft.getType().equals(String.class)) {
            return new StringEqExpr((ColumnExpr)newLeft, newRight);
        }
        if (newRight instanceof ColumnExpr && newRight.getType().equals(String.class)) {
            return new StringEqExpr((ColumnExpr)newRight, newLeft);
        }
        if ((newLeft instanceof ColumnExpr || newLeft instanceof IdExpr) && newLeft.getTypeCode() == Column.ColumnType.BINARY) {
            return new BinaryColumnEqExpr(newLeft, newRight);
        }
        if ((newRight instanceof ColumnExpr || newRight instanceof IdExpr) && newRight.getTypeCode() == Column.ColumnType.BINARY) {
            return new BinaryColumnEqExpr(newRight, newLeft);
        }
        if (newLeft.isLong() && (newRight.isLong() || newRight.isParam())) {
            return new LongEqExpr(newLeft, newRight);
        }
        if (newRight.isLong() && (newLeft.isLong() || newLeft.isParam())) {
            return new LongEqExpr(newLeft, newRight);
        }
        if (newLeft.isDouble() && (newRight.isDouble() || newRight.isParam())) {
            return new DoubleEqExpr(newLeft, newRight);
        }
        if (newRight.isDouble() && (newLeft.isDouble() || newLeft.isParam())) {
            return new DoubleEqExpr(newLeft, newRight);
        }
        if (this._left == newLeft && this._right == newRight) {
            return this;
        }
        return new EqExpr(newLeft, newRight);
    }

    @Override
    public RowIterateExpr getIndexExpr(FromItem item) {
        Expr expr;
        if (this._left instanceof IdExpr) {
            expr = (IdExpr)this._left;
            if (item == ((IdExpr)expr).getFromItem()) {
                if (((IdExpr)expr).getColumn().getTypeCode() == Column.ColumnType.IDENTITY) {
                    return new IdentityIndexExpr((IdExpr)expr, this._right);
                }
                if (((IdExpr)expr).getColumn().getIndex() != null) {
                    return new IndexExpr((IdExpr)expr, this._right);
                }
            }
        } else if (this._left instanceof OidExpr && item == ((OidExpr)(expr = (OidExpr)this._left)).getFromItem()) {
            return new OidIndexExpr((OidExpr)expr, this._right);
        }
        if (this._right instanceof IdExpr) {
            expr = (IdExpr)this._right;
            if (item == ((IdExpr)expr).getFromItem()) {
                if (((IdExpr)expr).getColumn().getTypeCode() == Column.ColumnType.IDENTITY) {
                    return new IdentityIndexExpr((IdExpr)expr, this._left);
                }
                if (((IdExpr)expr).getColumn().getIndex() != null) {
                    return new IndexExpr((IdExpr)expr, this._left);
                }
            }
        } else if (this._right instanceof OidExpr && item == ((OidExpr)(expr = (OidExpr)this._right)).getFromItem()) {
            return new OidIndexExpr((OidExpr)expr, this._left);
        }
        return null;
    }

    @Override
    public Class<?> getType() {
        return Boolean.TYPE;
    }

    @Override
    public long cost(ArrayList<FromItem> fromList) {
        if (this._left instanceof UnboundIdentifierExpr && this._right.cost(fromList) == 0L) {
            UnboundIdentifierExpr id = (UnboundIdentifierExpr)this._left;
            return id.lookupCost(fromList);
        }
        if (this._right instanceof UnboundIdentifierExpr && this._left.cost(fromList) == 0L) {
            UnboundIdentifierExpr id = (UnboundIdentifierExpr)this._right;
            return id.lookupCost(fromList);
        }
        return this.subCost(fromList);
    }

    @Override
    public long subCost(ArrayList<FromItem> fromList) {
        return this._left.subCost(fromList) + this._right.subCost(fromList);
    }

    @Override
    public long indexCost(ArrayList<FromItem> costItems) {
        long rightCost;
        long leftCost = this._left.indexSubCost(costItems);
        if (leftCost < (rightCost = this._right.indexSubCost(costItems))) {
            return leftCost;
        }
        return rightCost;
    }

    @Override
    public boolean isNull(QueryContext context) throws SQLException {
        return this._left.isNull(context) || this._right.isNull(context);
    }

    @Override
    public int evalBoolean(QueryContext context) throws SQLException {
        String rightValue;
        if (this._left.isNull(context) || this._right.isNull(context)) {
            return -1;
        }
        if (this._left.isLong() && this._right.isLong()) {
            if (this._left.evalLong(context) == this._right.evalLong(context)) {
                return 1;
            }
            return 0;
        }
        if (this._left.isDouble() && this._right.isDouble()) {
            if (this._left.evalDouble(context) == this._right.evalDouble(context)) {
                return 1;
            }
            return 0;
        }
        String leftValue = this._left.evalString(context);
        if (leftValue == (rightValue = this._right.evalString(context)) || leftValue.equals(rightValue)) {
            return 1;
        }
        return 0;
    }

    @Override
    public String evalString(QueryContext context) throws SQLException {
        throw new SQLException("can't convert string to boolean");
    }

    @Override
    public void evalGroup(QueryContext context) throws SQLException {
        this._left.evalGroup(context);
        this._right.evalGroup(context);
    }

    public String toString() {
        return "(" + this._left + " = " + this._right + ")";
    }
}

