/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.sql;

import com.caucho.db.jdbc.GeneratedKeysResultSet;
import com.caucho.db.sql.Expr;
import com.caucho.db.sql.QueryContext;
import com.caucho.db.table.Column;
import com.caucho.db.table.Table;
import com.caucho.db.table.TableIterator;
import java.sql.SQLException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class IdentityExpr
extends Expr {
    private Table _table;
    private Column _column;

    IdentityExpr(Table table, Column column) {
        this._table = table;
        this._column = column;
    }

    @Override
    public Class<?> getType() {
        return Long.TYPE;
    }

    @Override
    public long evalLong(QueryContext context) throws SQLException {
        GeneratedKeysResultSet keysRS = context.getGeneratedKeysResultSet();
        TableIterator[] rows = context.getTableIterators();
        TableIterator row = rows[0];
        long value = (row.getBlockId() & 0xFFFFFFFFFFFFE000L) + (long)row.getRowOffset();
        if (keysRS != null) {
            keysRS.setColumn(1, this._column);
            keysRS.setLong(1, value);
        }
        return value;
    }

    @Override
    public double evalDouble(QueryContext context) throws SQLException {
        return this.evalLong(context);
    }

    @Override
    public String evalString(QueryContext context) throws SQLException {
        return String.valueOf(this.evalLong(context));
    }

    public String toString() {
        return "identity()";
    }
}

