/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.sql;

import com.caucho.db.sql.Expr;
import com.caucho.db.sql.FunExpr;
import com.caucho.db.sql.GroupExpr;
import com.caucho.db.sql.Query;
import com.caucho.db.sql.QueryContext;
import com.caucho.util.L10N;
import java.sql.SQLException;

public class MinExpr
extends FunExpr
implements GroupExpr {
    private static final L10N L = new L10N(MinExpr.class);
    private Expr _expr;
    private int _groupField;
    private Class _type;

    protected void addArg(Expr expr) throws SQLException {
        if (this._expr != null) {
            throw new SQLException(L.l("min requires a single argument"));
        }
        this._expr = expr;
    }

    public Expr bind(Query query) throws SQLException {
        this._groupField = query.getDataFields();
        query.setDataFields(this._groupField + 1);
        query.setGroup(true);
        this._expr = this._expr.bind(query);
        this._type = this._expr.getType();
        return this;
    }

    public Class getType() {
        return this._type;
    }

    public void initGroup(QueryContext context) throws SQLException {
    }

    public void evalGroup(QueryContext context) throws SQLException {
        if (this._expr.isNull(context)) {
            return;
        }
        if (this._expr.isLong()) {
            long value = this._expr.evalLong(context);
            long oldValue = context.getGroupLong(this._groupField);
            if (context.isGroupNull(this._groupField)) {
                context.setGroupLong(this._groupField, value);
            } else if (value < oldValue) {
                context.setGroupLong(this._groupField, value);
            }
        } else {
            double value = this._expr.evalDouble(context);
            double oldValue = context.getGroupDouble(this._groupField);
            if (context.isGroupNull(this._groupField)) {
                context.setGroupDouble(this._groupField, value);
            } else if (value < oldValue) {
                context.setGroupDouble(this._groupField, value);
            }
        }
    }

    public boolean isNull(QueryContext context) throws SQLException {
        return context.isGroupNull(this._groupField);
    }

    public double evalDouble(QueryContext context) throws SQLException {
        return context.getGroupDouble(this._groupField);
    }

    public long evalLong(QueryContext context) throws SQLException {
        return context.getGroupLong(this._groupField);
    }

    public String evalString(QueryContext context) throws SQLException {
        return context.getGroupString(this._groupField);
    }
}

