/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.sql;

import com.caucho.db.block.BlockStore;
import com.caucho.db.sql.Expr;
import com.caucho.db.sql.FromItem;
import com.caucho.db.sql.QueryContext;
import com.caucho.db.sql.SelectQuery;
import com.caucho.db.table.TableIterator;
import com.caucho.util.CharBuffer;
import com.caucho.util.FreeList;
import com.caucho.util.L10N;
import com.caucho.vfs.TempBuffer;
import java.sql.SQLException;

public class SelectCursor {
    private static final L10N L = new L10N(SelectCursor.class);
    private static final FreeList<SelectCursor> _freeList = new FreeList(32);
    private static final int SIZE = TempBuffer.SIZE;
    private CharBuffer _cb = new CharBuffer();
    private byte[] _blob = new byte[128];
    private Expr[] _exprs;
    private BlockStore[] _stores = new BlockStore[32];
    private TableIterator[] _rows = new TableIterator[16];
    private int _row;
    private int _offset;
    private int _rowOffset;
    private int _columnOffset;
    private int _column;
    private boolean _wasNull;
    private boolean _isStart;
    private SelectQuery _query;
    private QueryContext _context;

    public SelectCursor(Expr[] exprs, SelectQuery query, QueryContext context) {
        this.init(exprs);
        this._query = query;
        this._context = context;
    }

    TableIterator[] initRows(FromItem[] fromItems) {
        if (this._rows.length < fromItems.length) {
            this._rows = new TableIterator[fromItems.length];
        }
        for (int i = 0; i < fromItems.length; ++i) {
            if (this._rows[i] == null) {
                this._rows[i] = new TableIterator();
            }
            this._rows[i].init(fromItems[i].getTable());
        }
        return this._rows;
    }

    TableIterator[] getRows() {
        return this._rows;
    }

    private void init(Expr[] exprs) {
        this._exprs = exprs;
        if (this._stores.length < this._exprs.length) {
            this._stores = new BlockStore[exprs.length];
        }
        for (int i = 0; i < exprs.length; ++i) {
            this._stores[i] = exprs[i].getTable();
        }
    }

    void initRead() throws SQLException {
        this._row = -1;
        this._offset = 0;
        this._column = 0;
        this._rowOffset = 0;
        this._columnOffset = 0;
    }

    public Expr[] getExprs() {
        return this._exprs;
    }

    public int findColumnIndex(String name) throws SQLException {
        for (int i = 0; i < this._exprs.length; ++i) {
            if (!this._exprs[i].getName().equals(name)) continue;
            return i + 1;
        }
        throw new SQLException(L.l("column `{0}' does not exist.", (Object)name));
    }

    public boolean next() throws SQLException {
        if (!this._isStart) {
            this._isStart = true;
            return true;
        }
        return this._query.nextCursor(this._rows, this._context, this._context.getTransaction());
    }

    public String getString(int i) throws SQLException {
        return this._exprs[i].evalString(this._context);
    }

    public void updateString(int i, String value) throws SQLException {
        this._exprs[i].updateString(this._context, value);
    }

    public int getInt(int i) throws SQLException {
        return (int)this._exprs[i].evalLong(this._context);
    }

    public void updateInt(int i, int value) throws SQLException {
        this._exprs[i].updateLong(this._context, value);
    }

    public long getLong(int i) throws SQLException {
        return this._exprs[i].evalLong(this._context);
    }

    public void updateLong(int i, long value) throws SQLException {
        this._exprs[i].updateLong(this._context, value);
    }

    public double getDouble(int i) throws SQLException {
        return this._exprs[i].evalDouble(this._context);
    }

    public void updateDouble(int i, double value) throws SQLException {
        this._exprs[i].updateDouble(this._context, value);
    }

    public byte[] getBytes(int i) throws SQLException {
        return this._exprs[i].evalBytes(this._context);
    }

    public void updateRow() {
    }

    public void close() {
    }
}

