/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.sql;

import com.caucho.db.blob.BlobInputStream;
import com.caucho.db.block.BlockStore;
import com.caucho.db.sql.BlobImpl;
import com.caucho.db.sql.ClobImpl;
import com.caucho.db.sql.Expr;
import com.caucho.db.sql.FromItem;
import com.caucho.db.sql.Order;
import com.caucho.db.table.Column;
import com.caucho.db.table.TableIterator;
import com.caucho.util.CharBuffer;
import com.caucho.util.FreeList;
import com.caucho.util.IntArray;
import com.caucho.util.L10N;
import com.caucho.util.QDate;
import com.caucho.util.SQLExceptionWrapper;
import com.caucho.vfs.TempBuffer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;

public class SelectResult {
    private static final L10N L = new L10N(SelectResult.class);
    private static final FreeList<SelectResult> _freeList = new FreeList(32);
    private static final int SIZE = TempBuffer.SIZE;
    private static QDate _date = new QDate();
    private final byte[] _tempBuffer = new byte[16];
    private final CharBuffer _cb = new CharBuffer();
    private final byte[] _blob = new byte[128];
    private Expr[] _exprs;
    private BlockStore[] _stores = new BlockStore[32];
    private TableIterator[] _rows = new TableIterator[16];
    private Order _order;
    private IntArray _orderIndex;
    private TempBuffer[] _tempBuffers = new TempBuffer[128];
    private byte[][] _buffers = new byte[128][];
    private int _length;
    private int _rowCount;
    private int _row;
    private int _offset;
    private int _rowOffset;
    private int _columnOffset;
    private int _column;
    private boolean _wasNull;

    private SelectResult() {
    }

    public static SelectResult create(Expr[] exprs, Order order) {
        SelectResult rs = _freeList.allocate();
        if (rs == null) {
            rs = new SelectResult();
        }
        rs.init(exprs, order);
        return rs;
    }

    TableIterator[] initRows(FromItem[] fromItems) {
        if (this._rows.length < fromItems.length) {
            this._rows = new TableIterator[fromItems.length];
        }
        for (int i = 0; i < fromItems.length; ++i) {
            if (this._rows[i] == null) {
                this._rows[i] = new TableIterator();
            }
            this._rows[i].init(fromItems[i].getTable());
        }
        return this._rows;
    }

    private void init(Expr[] exprs, Order order) {
        this._exprs = exprs;
        this._order = order;
        if (order != null) {
            this._orderIndex = new IntArray();
        }
        if (this._stores.length < this._exprs.length) {
            this._stores = new BlockStore[exprs.length];
        }
        for (int i = 0; i < exprs.length; ++i) {
            this._stores[i] = exprs[i].getTable();
        }
        this._length = 0;
        this._rowCount = 0;
    }

    void initRead() throws SQLException {
        if (this._order != null) {
            this._order.sort(this, this._orderIndex);
        }
        this._row = -1;
        this._offset = 0;
        this._column = 0;
        this._rowOffset = 0;
        this._columnOffset = 0;
    }

    public boolean next() throws SQLException {
        if (++this._row < this._rowCount) {
            if (this._orderIndex != null) {
                this._offset = this._orderIndex.get(this._row);
            } else if (this._row != 0) {
                this._offset = this._columnOffset;
                this.skipColumns(this._exprs.length - this._column);
            }
            this._column = 0;
            this._columnOffset = this._rowOffset = this._offset;
            return true;
        }
        return false;
    }

    public Expr[] getExprs() {
        return this._exprs;
    }

    public int findColumnIndex(String name) throws SQLException {
        for (int i = 0; i < this._exprs.length; ++i) {
            if (!this._exprs[i].getName().equals(name)) continue;
            return i + 1;
        }
        throw new SQLException(L.l("column `{0}' does not exist.", (Object)name));
    }

    public String getString(int index) throws SQLException {
        this._wasNull = false;
        this.setColumn(index);
        int type = this.read();
        if (type < 0) {
            return null;
        }
        Column.ColumnType cType = Column.ColumnType.values()[type];
        switch (cType) {
            case NONE: {
                this._wasNull = true;
                return null;
            }
            case SHORT: {
                short value = (short)((this.read() << 8) + this.read());
                return String.valueOf(value);
            }
            case INT: {
                int value = (this.read() << 24) + (this.read() << 16) + (this.read() << 8) + this.read();
                return String.valueOf(value);
            }
            case LONG: {
                long value = ((long)this.read() << 56) + ((long)this.read() << 48) + ((long)this.read() << 40) + ((long)this.read() << 32) + ((long)this.read() << 24) + ((long)this.read() << 16) + ((long)this.read() << 8) + (long)this.read();
                return String.valueOf(value);
            }
            case DOUBLE: {
                long value = ((long)this.read() << 56) + ((long)this.read() << 48) + ((long)this.read() << 40) + ((long)this.read() << 32) + ((long)this.read() << 24) + ((long)this.read() << 16) + ((long)this.read() << 8) + (long)this.read();
                return String.valueOf(Double.longBitsToDouble(value));
            }
            case DATE: {
                long value = ((long)this.read() << 56) + ((long)this.read() << 48) + ((long)this.read() << 40) + ((long)this.read() << 32) + ((long)this.read() << 24) + ((long)this.read() << 16) + ((long)this.read() << 8) + (long)this.read();
                return QDate.formatISO8601(value);
            }
            case VARCHAR: {
                return this.readString();
            }
            case BLOB: {
                return this.readBlobString();
            }
            case BINARY: {
                int len = this.read();
                char[] chars = new char[len];
                for (int i = 0; i < len; ++i) {
                    chars[i] = (char)(this.read() & 0xFF);
                }
                return new String(chars);
            }
        }
        throw new RuntimeException("unknown column type:" + type + " column:" + index);
    }

    public byte[] getBytes(int index) throws SQLException {
        this._wasNull = false;
        this.setColumn(index);
        int type = this.read();
        if (type < 0) {
            return null;
        }
        Column.ColumnType cType = Column.ColumnType.values()[type];
        switch (cType) {
            case NONE: {
                this._wasNull = true;
                return null;
            }
            case BINARY: {
                int len = this.read();
                byte[] bytes = new byte[len];
                this.read(bytes, 0, len);
                return bytes;
            }
            case BLOB: {
                return this.readBlobBytes();
            }
            case VARCHAR: {
                try {
                    return this.readString().getBytes("utf-8");
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        throw new RuntimeException("unknown column type:" + type + " column:" + index);
    }

    public int getInt(int index) throws SQLException {
        this._wasNull = false;
        this.setColumn(index);
        int type = this.read();
        if (type < 0) {
            return 0;
        }
        Column.ColumnType cType = Column.ColumnType.values()[type];
        switch (cType) {
            case NONE: {
                this._wasNull = true;
                return 0;
            }
            case SHORT: {
                short value = (short)((this.read() << 8) + this.read());
                return value;
            }
            case INT: {
                int value = (this.read() << 24) + (this.read() << 16) + (this.read() << 8) + this.read();
                return value;
            }
            case LONG: 
            case DATE: {
                long value = ((long)this.read() << 56) + ((long)this.read() << 48) + ((long)this.read() << 40) + ((long)this.read() << 32) + ((long)this.read() << 24) + ((long)this.read() << 16) + ((long)this.read() << 8) + (long)this.read();
                return (int)value;
            }
            case DOUBLE: {
                long value = ((long)this.read() << 56) + ((long)this.read() << 48) + ((long)this.read() << 40) + ((long)this.read() << 32) + ((long)this.read() << 24) + ((long)this.read() << 16) + ((long)this.read() << 8) + (long)this.read();
                return (int)Double.longBitsToDouble(value);
            }
            case VARCHAR: {
                return Integer.parseInt(this.readString());
            }
            case BLOB: {
                return Integer.parseInt(this.readBlobString());
            }
        }
        return 0;
    }

    public long getLong(int index) throws SQLException {
        this._wasNull = false;
        this.setColumn(index);
        int type = this.read();
        if (type < 0) {
            return 0L;
        }
        Column.ColumnType cType = Column.ColumnType.values()[type];
        switch (cType) {
            case NONE: {
                this._wasNull = true;
                return 0L;
            }
            case SHORT: {
                short value = (short)((this.read() << 8) + this.read());
                return value;
            }
            case INT: {
                int value = (this.read() << 24) + (this.read() << 16) + (this.read() << 8) + this.read();
                return value;
            }
            case LONG: 
            case DATE: {
                long value = ((long)this.read() << 56) + ((long)this.read() << 48) + ((long)this.read() << 40) + ((long)this.read() << 32) + ((long)this.read() << 24) + ((long)this.read() << 16) + ((long)this.read() << 8) + (long)this.read();
                return value;
            }
            case DOUBLE: {
                long value = ((long)this.read() << 56) + ((long)this.read() << 48) + ((long)this.read() << 40) + ((long)this.read() << 32) + ((long)this.read() << 24) + ((long)this.read() << 16) + ((long)this.read() << 8) + (long)this.read();
                return (long)Double.longBitsToDouble(value);
            }
            case VARCHAR: {
                return Long.parseLong(this.readString());
            }
            case BLOB: {
                return Long.parseLong(this.readBlobString());
            }
        }
        return 0L;
    }

    public double getDouble(int index) throws SQLException {
        this._wasNull = false;
        this.setColumn(index);
        int type = this.read();
        if (type < 0) {
            return 0.0;
        }
        Column.ColumnType cType = Column.ColumnType.values()[type];
        switch (cType) {
            case NONE: {
                this._wasNull = true;
                return 0.0;
            }
            case SHORT: {
                short value = (short)((this.read() << 8) + this.read());
                return value;
            }
            case INT: {
                int value = (this.read() << 24) + (this.read() << 16) + (this.read() << 8) + this.read();
                return value;
            }
            case LONG: 
            case DATE: {
                long value = ((long)this.read() << 56) + ((long)this.read() << 48) + ((long)this.read() << 40) + ((long)this.read() << 32) + ((long)this.read() << 24) + ((long)this.read() << 16) + ((long)this.read() << 8) + (long)this.read();
                return value;
            }
            case DOUBLE: {
                long value = ((long)this.read() << 56) + ((long)this.read() << 48) + ((long)this.read() << 40) + ((long)this.read() << 32) + ((long)this.read() << 24) + ((long)this.read() << 16) + ((long)this.read() << 8) + (long)this.read();
                return Double.longBitsToDouble(value);
            }
            case VARCHAR: {
                return Double.parseDouble(this.readString());
            }
            case BLOB: {
                return Double.parseDouble(this.readBlobString());
            }
        }
        return 0.0;
    }

    public long getDate(int index) throws SQLException {
        this._wasNull = false;
        this.setColumn(index);
        int type = this.read();
        if (type < 0) {
            return 0L;
        }
        Column.ColumnType cType = Column.ColumnType.values()[type];
        switch (cType) {
            case NONE: {
                this._wasNull = true;
                return 0L;
            }
            case LONG: 
            case DATE: {
                long value = ((long)this.read() << 56) + ((long)this.read() << 48) + ((long)this.read() << 40) + ((long)this.read() << 32) + ((long)this.read() << 24) + ((long)this.read() << 16) + ((long)this.read() << 8) + (long)this.read();
                return value;
            }
            case INT: {
                long value = ((long)this.read() << 24) + ((long)this.read() << 16) + ((long)this.read() << 8) + (long)this.read();
                return value;
            }
            case VARCHAR: {
                String value = this.readString();
                QDate qDate = _date;
                synchronized (qDate) {
                    try {
                        return _date.parseDate(value);
                    }
                    catch (Exception e) {
                        throw new SQLExceptionWrapper(e);
                    }
                }
            }
            case BLOB: {
                String value = this.readBlobString();
                QDate qDate = _date;
                synchronized (qDate) {
                    try {
                        return _date.parseDate(value);
                    }
                    catch (Exception e) {
                        throw new SQLExceptionWrapper(e);
                    }
                }
            }
        }
        throw new SQLException("unknown type: " + type);
    }

    public InputStream getBinaryStream(int index) throws SQLException {
        this._wasNull = false;
        this.setColumn(index);
        int type = this.read();
        if (type < 0) {
            return null;
        }
        Column.ColumnType cType = Column.ColumnType.values()[type];
        switch (cType) {
            case NONE: {
                this._wasNull = true;
                return null;
            }
            case BINARY: {
                int len = this.read();
                byte[] bytes = new byte[len];
                this.read(bytes, 0, len);
                return new ByteArrayInputStream(bytes);
            }
            case BLOB: {
                return this.getBlob().getBinaryStream();
            }
        }
        throw new RuntimeException("column " + (Object)((Object)cType) + " can't be retrieved as a blob:" + type + " column:" + index);
    }

    public Blob getBlob(int index) throws SQLException {
        this._wasNull = false;
        this.setColumn(index);
        int type = this.read();
        if (type < 0) {
            return null;
        }
        Column.ColumnType cType = Column.ColumnType.values()[type];
        switch (cType) {
            case NONE: {
                this._wasNull = true;
                return null;
            }
            case BLOB: {
                return this.getBlob();
            }
        }
        throw new RuntimeException("column " + (Object)((Object)cType) + " can't be retrieved as a blob:" + type + " column:" + index);
    }

    public Clob getClob(int index) throws SQLException {
        this._wasNull = false;
        this.setColumn(index);
        int type = this.read();
        if (type < 0) {
            return null;
        }
        Column.ColumnType cType = Column.ColumnType.values()[type];
        switch (cType) {
            case NONE: {
                this._wasNull = true;
                return null;
            }
            case BLOB: {
                return this.getClob();
            }
        }
        throw new RuntimeException("column can't be retrieved as a clob:" + type + " column:" + index);
    }

    public boolean wasNull() {
        return this._wasNull;
    }

    private String readString() throws SQLException {
        int len;
        int length = (this.read() << 24) + (this.read() << 16) + (this.read() << 8) + this.read();
        CharBuffer cb = this._cb;
        cb.ensureCapacity(len);
        char[] cBuf = cb.getBuffer();
        int cLen = 0;
        for (len = length >> 1; len > 0; --len) {
            int ch1 = this.read();
            int ch2 = this.read();
            cBuf[cLen++] = (char)(((ch1 & 0xFF) << 8) + (ch2 & 0xFF));
        }
        return new String(cBuf, 0, cLen);
    }

    private Blob getBlob() throws SQLException {
        BlobImpl blob = new BlobImpl();
        blob.setStore(this._stores[this._column]);
        byte[] inode = blob.getInode();
        this.read(inode, 0, 128);
        return blob;
    }

    private Clob getClob() throws SQLException {
        ClobImpl clob = new ClobImpl();
        clob.setStore(this._stores[this._column]);
        byte[] inode = clob.getInode();
        this.read(inode, 0, 128);
        return clob;
    }

    private String readBlobString() throws SQLException {
        this.read(this._blob, 0, 128);
        CharBuffer cb = this._cb;
        cb.clear();
        BlobInputStream is = null;
        try {
            int ch;
            is = new BlobInputStream(this._stores[this._column], this._blob, 0);
            while ((ch = is.read()) >= 0) {
                if (ch >= 128) continue;
                cb.append((char)ch);
            }
        }
        catch (IOException e) {
            throw new SQLExceptionWrapper(e);
        }
        return cb.toString();
    }

    private byte[] readBlobBytes() throws SQLException {
        this.read(this._blob, 0, 128);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        BlobInputStream is = null;
        try {
            int ch;
            is = new BlobInputStream(this._stores[this._column], this._blob, 0);
            while ((ch = is.read()) >= 0) {
                bos.write(ch);
            }
        }
        catch (IOException e) {
            throw new SQLExceptionWrapper(e);
        }
        return bos.toByteArray();
    }

    private void setColumn(int column) {
        if (column < this._column) {
            this._offset = this._rowOffset;
            this.skipColumns(column);
        } else {
            this._offset = this._columnOffset;
            this.skipColumns(column - this._column);
        }
        this._column = column;
        this._columnOffset = this._offset;
    }

    void setRow(int rowOffset) {
        this._rowOffset = rowOffset;
        this._offset = rowOffset;
        this._column = 0;
        this._columnOffset = rowOffset;
    }

    private void skipColumns(int count) {
        while (count > 0) {
            int type = this.read();
            if (type < 0) {
                return;
            }
            Column.ColumnType cType = Column.ColumnType.values()[type];
            switch (cType) {
                case NONE: {
                    break;
                }
                case VARCHAR: {
                    int l0 = this.read();
                    int l1 = this.read();
                    int l2 = this.read();
                    int l3 = this.read();
                    int sublen = (l0 << 24) + (l1 << 16) + (l2 << 8) + l3;
                    this._offset += sublen;
                    break;
                }
                case BINARY: {
                    int sublen = this.read();
                    this._offset += sublen;
                    break;
                }
                case SHORT: {
                    this._offset += 2;
                    break;
                }
                case INT: {
                    this._offset += 4;
                    break;
                }
                case LONG: 
                case DOUBLE: 
                case DATE: {
                    this._offset += 8;
                    break;
                }
                case BLOB: {
                    this._offset += 128;
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown column type: " + type);
                }
            }
            --count;
        }
    }

    public void startRow() {
        if (this._orderIndex != null) {
            this._orderIndex.add(this._length);
        }
        ++this._rowCount;
    }

    public void writeNull() {
        this.write(Column.ColumnType.NONE.ordinal());
    }

    public void writeString(String s) {
        this.write(Column.ColumnType.VARCHAR.ordinal());
        int stringLength = s.length();
        int length = 2 * stringLength;
        this.write(length >> 24);
        this.write(length >> 16);
        this.write(length >> 8);
        this.write(length);
        for (int i = 0; i < stringLength; ++i) {
            char ch = s.charAt(i);
            this.write(ch << 8);
            this.write(ch);
        }
    }

    public void writeString(byte[] buffer, int offset, int stringLength) {
        int rLength = this._length;
        int rOffset = rLength % SIZE;
        int rBlockId = rLength / SIZE;
        if (this._buffers[rBlockId] == null) {
            TempBuffer tempBuffer;
            this._tempBuffers[rBlockId] = tempBuffer = TempBuffer.allocate();
            this._buffers[rBlockId] = tempBuffer.getBuffer();
        }
        byte[] rBuffer = this._buffers[rBlockId];
        rBuffer[rOffset] = (byte)Column.ColumnType.VARCHAR.ordinal();
        int length = 2 * stringLength;
        if (rOffset + 5 < rBuffer.length) {
            rBuffer[rOffset + 1] = (byte)(length >> 24);
            rBuffer[rOffset + 2] = (byte)(length >> 16);
            rBuffer[rOffset + 3] = (byte)(length >> 8);
            rBuffer[rOffset + 4] = (byte)length;
            if (rOffset + 5 + length < SIZE) {
                System.arraycopy(buffer, offset, rBuffer, rOffset + 5, length);
                this._length = rLength + 5 + length;
            } else {
                this._length = rLength + 5;
                this.write(buffer, offset, length);
            }
        } else {
            this._length = rLength + 1;
            this.write(length >> 24);
            this.write(length >> 16);
            this.write(length >> 8);
            this.write(length);
            this.write(buffer, offset, length);
        }
    }

    public void writeBinary(byte[] buffer, int offset, int length) {
        this.write(Column.ColumnType.BINARY.ordinal());
        this.write(length);
        this.write(buffer, offset, length);
    }

    public void writeBlock(int code, byte[] buffer, int offset, int length) {
        this.write(code);
        this.write(buffer, offset, length);
    }

    public void writeDouble(double dValue) {
        this.write(Column.ColumnType.DOUBLE.ordinal());
        long value = Double.doubleToLongBits(dValue);
        this.write((int)(value >> 56));
        this.write((int)(value >> 48));
        this.write((int)(value >> 40));
        this.write((int)(value >> 32));
        this.write((int)(value >> 24));
        this.write((int)(value >> 16));
        this.write((int)(value >> 8));
        this.write((int)value);
    }

    public void writeLong(long value) {
        byte[] buffer = this._tempBuffer;
        buffer[0] = (byte)Column.ColumnType.LONG.ordinal();
        buffer[1] = (byte)(value >> 56);
        buffer[2] = (byte)(value >> 48);
        buffer[3] = (byte)(value >> 40);
        buffer[4] = (byte)(value >> 32);
        buffer[5] = (byte)(value >> 24);
        buffer[6] = (byte)(value >> 16);
        buffer[7] = (byte)(value >> 8);
        buffer[8] = (byte)value;
        this.write(buffer, 0, 9);
    }

    public void writeDate(long value) {
        this.write(Column.ColumnType.DATE.ordinal());
        this.write((int)(value >> 56));
        this.write((int)(value >> 48));
        this.write((int)(value >> 40));
        this.write((int)(value >> 32));
        this.write((int)(value >> 24));
        this.write((int)(value >> 16));
        this.write((int)(value >> 8));
        this.write((int)value);
    }

    public void writeInt(int value) {
        this.write(Column.ColumnType.INT.ordinal());
        this.write(value >> 24);
        this.write(value >> 16);
        this.write(value >> 8);
        this.write(value);
    }

    public void writeShort(int value) {
        this.write(Column.ColumnType.SHORT.ordinal());
        this.write(value >> 8);
        this.write(value);
    }

    public void writeBlob(byte[] buffer, int offset) {
        this.write(Column.ColumnType.BLOB.ordinal());
        this.write(buffer, offset, 128);
    }

    private int read() {
        int offset = this._offset;
        if (this._length <= offset) {
            return -1;
        }
        this._offset = offset + 1;
        byte[] buf = this._buffers[offset / SIZE];
        return buf[offset % SIZE] & 0xFF;
    }

    private int read(byte[] buffer, int bufOffset, int bufLength) {
        int offset = this._offset;
        int length = this._length;
        byte[][] buffers = this._buffers;
        for (int i = bufLength; i > 0; --i) {
            if (length <= offset) {
                this._offset = offset;
                return -1;
            }
            byte[] buf = buffers[offset / SIZE];
            buffer[bufOffset] = buf[offset % SIZE];
            ++offset;
            ++bufOffset;
        }
        this._offset = offset;
        return bufLength;
    }

    public void write(int value) {
        int length = this._length;
        int rOffset = length % SIZE;
        int blockId = length / SIZE;
        while (this._buffers.length <= blockId) {
            byte[][] newBuffers = new byte[2 * this._buffers.length][];
            System.arraycopy(this._buffers, 0, newBuffers, 0, this._buffers.length);
            this._buffers = newBuffers;
            TempBuffer[] newTempBuffers = new TempBuffer[newBuffers.length];
            System.arraycopy(this._tempBuffers, 0, newTempBuffers, 0, this._tempBuffers.length);
            this._tempBuffers = newTempBuffers;
        }
        byte[] buffer = this._buffers[blockId];
        if (buffer == null) {
            TempBuffer tempBuffer;
            this._tempBuffers[blockId] = tempBuffer = TempBuffer.allocate();
            this._buffers[blockId] = tempBuffer.getBuffer();
            buffer = this._buffers[blockId];
        }
        buffer[rOffset] = (byte)value;
        this._length = length + 1;
    }

    public void write(byte[] buffer, int offset, int length) {
        int rLength = this._length;
        while (length > 0) {
            byte[] rBuffer;
            int sublen;
            int rOffset = rLength % SIZE;
            int rBufferId = rLength / SIZE;
            if (rOffset == 0) {
                TempBuffer tempBuffer = TempBuffer.allocate();
                if (this._tempBuffers.length <= rBufferId) {
                    int len = this._tempBuffers.length;
                    TempBuffer[] newTempBuffers = new TempBuffer[len + 32];
                    System.arraycopy(this._tempBuffers, 0, newTempBuffers, 0, len);
                    this._tempBuffers = newTempBuffers;
                    byte[][] newBuffers = new byte[len + 32][];
                    System.arraycopy(this._buffers, 0, newBuffers, 0, len);
                    this._buffers = newBuffers;
                }
                this._tempBuffers[rBufferId] = tempBuffer;
                this._buffers[rBufferId] = tempBuffer.getBuffer();
            }
            if (length < (sublen = (rBuffer = this._buffers[rBufferId]).length - rOffset)) {
                sublen = length;
            }
            System.arraycopy(buffer, offset, rBuffer, rOffset, sublen);
            length -= sublen;
            offset += sublen;
            rLength += sublen;
        }
        this._length = rLength;
    }

    public void close() {
        int i;
        for (i = 0; i < this._buffers.length; ++i) {
            TempBuffer buffer = this._tempBuffers[i];
            if (buffer != null) {
                TempBuffer.free(buffer);
            }
            this._tempBuffers[i] = null;
            this._buffers[i] = null;
        }
        for (i = this._stores.length - 1; i >= 0; --i) {
            this._stores[i] = null;
        }
        this._order = null;
        this._orderIndex = null;
        _freeList.free(this);
    }
}

