/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.cfg;

import com.caucho.config.ConfigException;
import com.caucho.config.reflect.AnnotatedMethodImpl;
import com.caucho.ejb.cfg.AccessTimeoutLiteral;
import com.caucho.ejb.cfg.BeanMethod;
import com.caucho.ejb.cfg.EjbMethodPattern;
import com.caucho.ejb.cfg.EjbTimeout;
import com.caucho.ejb.cfg.LockLiteral;
import com.caucho.util.L10N;
import javax.annotation.PostConstruct;
import javax.ejb.LockType;
import javax.enterprise.inject.spi.AnnotatedMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConcurrentMethod<X>
extends EjbMethodPattern<X> {
    private static final L10N L = new L10N(ConcurrentMethod.class);
    private BeanMethod _beanMethod;
    private AccessTimeoutLiteral _accessTimeout;
    private LockType _lock;

    public void setMethod(BeanMethod beanMethod) {
        this._beanMethod = beanMethod;
    }

    public void setAccessTimeout(EjbTimeout timeout) {
        this._accessTimeout = new AccessTimeoutLiteral(timeout.getTimeoutValue());
    }

    public void setLock(String lock) {
        if ("Read".equals(lock)) {
            this._lock = LockType.READ;
        } else if ("Write".equals(lock)) {
            this._lock = LockType.WRITE;
        } else {
            throw new ConfigException(L.l("'{0}' is an unknown lock type", (Object)lock));
        }
    }

    @PostConstruct
    public void init() {
        this.setSignature(this._beanMethod.getSignature());
    }

    @Override
    public boolean isMatch(AnnotatedMethod<?> method) {
        return this._beanMethod.isMatch(method);
    }

    @Override
    public void configure(AnnotatedMethod<?> method) {
        if (this.isMatch(method)) {
            AnnotatedMethodImpl methodImpl = (AnnotatedMethodImpl)method;
            if (this._accessTimeout != null) {
                methodImpl.addAnnotation(this._accessTimeout);
            }
            if (this._lock != null) {
                methodImpl.addAnnotation(new LockLiteral(this._lock));
            }
        }
    }
}

