/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.cfg;

import com.caucho.config.Config;
import com.caucho.config.ConfigException;
import com.caucho.config.inject.InjectManager;
import com.caucho.ejb.cfg.EjbConfig;
import com.caucho.ejb.cfg.EjbJar;
import com.caucho.ejb.cfg.EjbRootConfig;
import com.caucho.ejb.manager.EjbManager;
import com.caucho.loader.Environment;
import com.caucho.loader.EnvironmentClassLoader;
import com.caucho.server.webapp.WebApp;
import com.caucho.util.L10N;
import com.caucho.vfs.JarPath;
import com.caucho.vfs.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.ManagedBean;
import javax.enterprise.inject.spi.AnnotatedType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EjbConfigManager
extends EjbConfig {
    private static final L10N L = new L10N(EjbConfigManager.class);
    private static final Logger log = Logger.getLogger(EjbConfigManager.class.getName());
    private final HashMap<Path, EjbRootConfig> _rootConfigMap = new HashMap();
    private final ArrayList<EjbRootConfig> _rootPendingList = new ArrayList();
    private final ArrayList<Path> _pathPendingList = new ArrayList();

    public EjbConfigManager(EjbManager ejbContainer) {
        super(ejbContainer);
    }

    public EjbRootConfig createRootConfig(Path root) {
        EjbRootConfig rootConfig = this._rootConfigMap.get(root);
        if (rootConfig == null) {
            rootConfig = new EjbRootConfig(root);
            this._rootConfigMap.put(root, rootConfig);
            this._rootPendingList.add(rootConfig);
            String ejbModuleName = null;
            WebApp webApp = WebApp.getCurrent();
            ejbModuleName = webApp != null ? webApp.getWarName() : this.getEjbModuleName(root);
            Path ejbJarXml = this.getEjbJarPath(root);
            if (ejbJarXml != null) {
                EjbJar ejbJar = this.configurePath(root, ejbJarXml, ejbModuleName);
                rootConfig.setModuleName(ejbJar.getModuleName());
            } else {
                rootConfig.setModuleName(ejbModuleName);
            }
        }
        return rootConfig;
    }

    private Path getEjbJarPath(Path root) {
        Path ejbJarXml = root.lookup("META-INF/ejb-jar.xml");
        if (ejbJarXml.canRead()) {
            return ejbJarXml;
        }
        if (root.getFullPath().endsWith("WEB-INF/classes/")) {
            ejbJarXml = root.lookup("../ejb-jar.xml");
        }
        if (ejbJarXml.canRead()) {
            return ejbJarXml;
        }
        return null;
    }

    public void configureRootPath(Path root) {
        String ejbModuleName = null;
        WebApp webApp = WebApp.getCurrent();
        ejbModuleName = webApp != null ? webApp.getWarName() : this.getEjbModuleName(root);
        Path ejbJarXml = this.getEjbJarPath(root);
        if (ejbJarXml != null) {
            this.configurePath(root, ejbJarXml, ejbModuleName);
        }
    }

    public void start() {
        InjectManager.create().update();
        ArrayList<EjbRootConfig> pendingList = new ArrayList<EjbRootConfig>(this._rootPendingList);
        this._rootPendingList.clear();
        for (EjbRootConfig rootConfig : pendingList) {
            for (String className : rootConfig.getClassNameList()) {
                this.addClassByName(className, rootConfig.getModuleName());
            }
        }
        this.configurePaths();
        this.configure();
        this.deploy();
    }

    private <X> void addClassByName(String className, String moduleName) {
        try {
            EnvironmentClassLoader loader = this._ejbManager.getClassLoader();
            InjectManager manager = InjectManager.create(loader);
            Class<X> type = this.loadClass(className, loader);
            AnnotatedType<X> annType = manager.createAnnotatedType(type);
            if (annType.isAnnotationPresent(ManagedBean.class)) {
                manager.discoverBean(annType);
                return;
            }
            this.addAnnotatedType(annType, annType, null, moduleName);
        }
        catch (ConfigException e) {
            throw e;
        }
        catch (Exception e) {
            throw ConfigException.create(e);
        }
    }

    private <X> Class<X> loadClass(String className, ClassLoader loader) throws ClassNotFoundException {
        return Class.forName(className, false, loader);
    }

    @Override
    public void addEjbPath(Path root) {
        if (this._pathPendingList.contains(root)) {
            return;
        }
        this._pathPendingList.add(root);
    }

    private String getEjbModuleName(Path root) {
        if (root instanceof JarPath) {
            String jarName = ((JarPath)root).getContainer().getTail();
            return jarName.substring(0, jarName.length() - ".jar".length());
        }
        return root.getTail();
    }

    private EjbJar configurePath(Path root) {
        return this.configurePath(root, this.getEjbJarPath(root), this.getEjbModuleName(root));
    }

    private EjbJar configurePath(Path root, Path ejbJarPath, String ejbModuleName) {
        Path path;
        if (root.getScheme().equals("jar")) {
            root.setUserPath(root.getURL());
        }
        if ((path = ejbJarPath) == null) {
            return null;
        }
        Environment.addDependency(path);
        EjbJar ejbJar = new EjbJar(this, ejbModuleName, path);
        try {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this + " reading " + root.getURL());
            }
            new Config().configure((Object)ejbJar, path, this.getSchema());
            return ejbJar;
        }
        catch (ConfigException e) {
            throw e;
        }
        catch (Exception e) {
            throw ConfigException.create(e);
        }
    }

    private void configurePaths() {
        ArrayList<Path> pathList = new ArrayList<Path>(this._pathPendingList);
        this._pathPendingList.clear();
        for (Path path : pathList) {
            this.configurePath(path);
        }
    }
}

