/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.gen;

import com.caucho.config.ConfigException;
import com.caucho.config.gen.AspectBeanFactory;
import com.caucho.config.gen.AspectGenerator;
import com.caucho.config.gen.BeanGenerator;
import com.caucho.config.reflect.AnnotatedTypeUtil;
import com.caucho.ejb.gen.NonBusinessAspectBeanFactory;
import com.caucho.inject.Module;
import com.caucho.java.JavaWriter;
import com.caucho.util.L10N;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ejb.LocalBean;
import javax.ejb.Schedule;
import javax.ejb.Schedules;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Module
public abstract class SessionGenerator<X>
extends BeanGenerator<X> {
    private static final L10N L = new L10N(SessionGenerator.class);
    private boolean _hasNoInterfaceView;
    private ArrayList<AnnotatedType<? super X>> _localApi;
    private AnnotatedType<X> _localBean;
    private ArrayList<AnnotatedType<? super X>> _remoteApi;
    private ArrayList<AnnotatedMethod<? super X>> _annotatedMethods = new ArrayList();
    protected String _contextClassName = "dummy";
    private final NonBusinessAspectBeanFactory<X> _nonBusinessAspectBeanFactory;
    private final ArrayList<AspectGenerator<X>> _businessMethods = new ArrayList();

    public SessionGenerator(String ejbName, AnnotatedType<X> beanType, ArrayList<AnnotatedType<? super X>> localApi, AnnotatedType<X> localBean, ArrayList<AnnotatedType<? super X>> remoteApi, String beanTypeName) {
        super(SessionGenerator.toFullClassName(ejbName, beanType.getJavaClass().getName(), beanTypeName), beanType);
        this._localApi = new ArrayList<AnnotatedType<X>>(localApi);
        this._localBean = localBean;
        this._remoteApi = new ArrayList<AnnotatedType<X>>(remoteApi);
        this._nonBusinessAspectBeanFactory = new NonBusinessAspectBeanFactory(this.getBeanType());
    }

    public static String toFullClassName(String ejbName, String className, String beanType) {
        StringBuilder sb = new StringBuilder();
        sb.append(className);
        sb.append("__");
        if (!className.endsWith(ejbName)) {
            for (int i = 0; i < ejbName.length(); ++i) {
                char ch = ejbName.charAt(i);
                if (ch == '/') {
                    sb.append('_');
                    continue;
                }
                if (Character.isJavaIdentifierPart(ch)) {
                    sb.append(ch);
                    continue;
                }
                sb.append('_');
            }
        }
        sb.append(beanType);
        sb.append("Proxy");
        return sb.toString();
    }

    public boolean isStateless() {
        return false;
    }

    public boolean hasNoInterfaceView() {
        return this.getLocalBean() != null;
    }

    public ArrayList<AnnotatedType<? super X>> getLocalApi() {
        return this._localApi;
    }

    public AnnotatedType<X> getLocalBean() {
        return this._localBean;
    }

    public ArrayList<AnnotatedType<? super X>> getRemoteApi() {
        return this._remoteApi;
    }

    protected ArrayList<AnnotatedMethod<? super X>> getAnnotatedMethods() {
        return this._annotatedMethods;
    }

    @Override
    public ArrayList<AspectGenerator<X>> getMethods() {
        return this._businessMethods;
    }

    @Override
    public void introspect() {
        super.introspect();
        if (this.getBeanType().isAnnotationPresent(LocalBean.class) && !this.getBeanType().getJavaClass().isInterface()) {
            this._hasNoInterfaceView = true;
        }
        if (this._localApi.size() == 0 && this._remoteApi.size() == 0) {
            this._hasNoInterfaceView = true;
        }
        if (this._hasNoInterfaceView) {
            AnnotatedType<X> localDefault = this.introspectLocalDefault();
            if (localDefault.getJavaClass().isInterface()) {
                this._localApi.add(localDefault);
            } else {
                this.introspectType(localDefault);
            }
        }
        for (AnnotatedType<? super X> annotatedType : this._localApi) {
            this.introspectType(annotatedType);
        }
        for (AnnotatedType<? super X> annotatedType : this._remoteApi) {
            this.introspectType(annotatedType);
        }
        this.introspectImpl();
        if (this.isTimerSupported()) {
            this.introspectTimerMethods();
        }
    }

    private void introspectType(AnnotatedType<? super X> type) {
        for (AnnotatedMethod<X> annotatedMethod : type.getMethods()) {
            this.introspectMethod(annotatedMethod);
        }
    }

    private void introspectMethod(AnnotatedMethod<? super X> method) {
        AnnotatedMethod<? super X> oldMethod = this.findMethod(this._annotatedMethods, method);
        if (oldMethod != null) {
            return;
        }
        AnnotatedMethod<? super X> baseMethod = this.findMethod(this.getBeanType().getMethods(), method);
        if (baseMethod == null) {
            throw new IllegalStateException(L.l("{0} does not have a matching base method in {1}", (Object)method, (Object)this.getBeanType()));
        }
        this._annotatedMethods.add(baseMethod);
    }

    private void introspectImpl() {
        for (AnnotatedMethod<X> method : this.getAnnotatedMethods()) {
            this.introspectMethodImpl(method);
        }
        for (AnnotatedMethod<X> method : this.getBeanType().getMethods()) {
            Method javaMethod = method.getJavaMember();
            if (method.isAnnotationPresent(PostConstruct.class) && javaMethod.getParameterTypes().length == 0) {
                this.addPostConstructMethod(method);
                continue;
            }
            if (!method.isAnnotationPresent(PreDestroy.class) || javaMethod.getParameterTypes().length != 0) continue;
            this.addPreDestroyMethod(method);
        }
    }

    private void introspectMethodImpl(AnnotatedMethod<? super X> apiMethod) {
        Method javaMethod = apiMethod.getJavaMember();
        if (SessionGenerator.isBusinessMethod(javaMethod)) {
            this.addBusinessMethod(apiMethod);
        } else {
            if (javaMethod.getName().startsWith("ejb")) {
                throw new ConfigException(L.l("{0}: '{1}' must not start with 'ejb'.  The EJB spec reserves all methods starting with ejb.", (Object)javaMethod.getDeclaringClass(), (Object)javaMethod.getName()));
            }
            int modifiers = javaMethod.getModifiers();
            if (!(Modifier.isPublic(modifiers) || Modifier.isPrivate(modifiers) || Modifier.isStatic(modifiers) || javaMethod.isSynthetic() || javaMethod.isBridge())) {
                this.addNonBusinessMethod(apiMethod);
            }
        }
    }

    private void introspectTimerMethods() {
        for (AnnotatedMethod<X> method : this.getAnnotatedMethods()) {
            this.introspectTimerMethod(method);
        }
    }

    private void introspectTimerMethod(AnnotatedMethod<? super X> apiMethod) {
        Method javaMethod = apiMethod.getJavaMember();
        int modifiers = javaMethod.getModifiers();
        if (!SessionGenerator.isBusinessMethod(javaMethod) && !Modifier.isPublic(modifiers) && (javaMethod.isAnnotationPresent(Schedule.class) || javaMethod.isAnnotationPresent(Schedules.class))) {
            this.addScheduledMethod(apiMethod);
        }
    }

    protected void addBusinessMethod(AnnotatedMethod<? super X> method) {
        AspectGenerator<? super X> bizMethod = this.getAspectBeanFactory().create(method);
        if (bizMethod != null && !this._businessMethods.contains(bizMethod)) {
            this._businessMethods.add(bizMethod);
        }
    }

    protected void addPostConstructMethod(AnnotatedMethod<? super X> method) {
        if (this.getLifecycleAspectFactory() == null) {
            return;
        }
        AspectGenerator<? super X> initMethod = this.getLifecycleAspectFactory().create(method);
        if (initMethod != null) {
            this._businessMethods.add(initMethod);
        }
    }

    protected void addPreDestroyMethod(AnnotatedMethod<? super X> method) {
        if (this.getLifecycleAspectFactory() == null) {
            return;
        }
        AspectGenerator<? super X> initMethod = this.getLifecycleAspectFactory().create(method);
        if (initMethod != null) {
            this._businessMethods.add(initMethod);
        }
    }

    protected void addNonBusinessMethod(AnnotatedMethod<? super X> method) {
        AspectGenerator<? super X> nonBizMethod = this._nonBusinessAspectBeanFactory.create(method);
        if (nonBizMethod != null) {
            this._businessMethods.add(nonBizMethod);
        }
    }

    protected void addScheduledMethod(AnnotatedMethod<? super X> method) {
        AspectGenerator<? super X> bizMethod = this.getScheduledAspectBeanFactory().create(method);
        if (bizMethod != null) {
            this._businessMethods.add(bizMethod);
        }
    }

    private AnnotatedMethod<? super X> findMethod(Collection<AnnotatedMethod<? super X>> methodList, AnnotatedMethod<? super X> method) {
        for (AnnotatedMethod<X> annotatedMethod : methodList) {
            if (!AnnotatedTypeUtil.isMatch(annotatedMethod, method)) continue;
            return annotatedMethod;
        }
        return null;
    }

    protected AnnotatedType<? super X> introspectLocalDefault() {
        return this.getBeanType();
    }

    protected void generateContentImpl(JavaWriter out, HashMap<String, Object> map) throws IOException {
        this.generateBeanPrologue(out, map);
        this.generateBusinessMethods(out, map);
        this.generateEpilogue(out, map);
        this.generateInject(out, map);
        this.generateDelegate(out, map);
        this.generatePostConstruct(out, map);
        this.generateDestroy(out, map);
    }

    @Override
    protected void generatePostConstruct(JavaWriter out, HashMap<String, Object> map) throws IOException {
        this.generatePostConstructImpl(out, map);
    }

    protected AspectBeanFactory<X> getScheduledAspectBeanFactory() {
        throw new UnsupportedOperationException();
    }

    protected abstract boolean isTimerSupported();

    @Override
    protected abstract AspectBeanFactory<X> getAspectBeanFactory();

    @Override
    protected AspectBeanFactory<X> getLifecycleAspectFactory() {
        return null;
    }

    public static boolean isBusinessMethod(Method method) {
        int modifiers;
        if (method.getDeclaringClass().equals(Object.class)) {
            return false;
        }
        if (method.getDeclaringClass().getName().startsWith("javax.ejb.")) {
            return false;
        }
        if (method.getName().startsWith("ejb")) {
            // empty if block
        }
        if (!Modifier.isPublic(modifiers = method.getModifiers())) {
            return false;
        }
        return !Modifier.isFinal(modifiers) && !Modifier.isStatic(modifiers);
    }
}

