/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.gen;

import com.caucho.config.gen.AspectGenerator;
import com.caucho.config.gen.MethodHeadGenerator;
import com.caucho.ejb.gen.SingletonMethodHeadFactory;
import com.caucho.inject.Module;
import com.caucho.java.JavaWriter;
import java.io.IOException;
import javax.ejb.TransactionAttributeType;
import javax.enterprise.inject.spi.AnnotatedMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Module
public class SingletonMethodHeadGenerator<X>
extends MethodHeadGenerator<X> {
    public SingletonMethodHeadGenerator(SingletonMethodHeadFactory<X> factory, AnnotatedMethod<? super X> method, AspectGenerator<X> next) {
        super(factory, method, next);
    }

    protected TransactionAttributeType getDefaultTransactionType() {
        return TransactionAttributeType.REQUIRED;
    }

    @Override
    public void generatePreTry(JavaWriter out) throws IOException {
        super.generatePreTry(out);
        out.println("if (! _isValid)");
        out.println("  throw new javax.ejb.NoSuchEJBException(\"singleton instance " + this.getJavaClass().getSimpleName() + " is no longer valid\");");
        out.println("Thread thread = Thread.currentThread();");
        out.println("ClassLoader oldLoader = thread.getContextClassLoader();");
    }

    @Override
    public void generatePreCall(JavaWriter out) throws IOException {
        out.println("thread.setContextClassLoader(_manager.getClassLoader());");
        super.generatePreCall(out);
    }

    @Override
    public void generateFinally(JavaWriter out) throws IOException {
        out.println("thread.setContextClassLoader(oldLoader);");
        super.generateFinally(out);
    }
}

