/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.gen;

import com.caucho.ejb.gen.StatelessMethodTailGenerator;
import com.caucho.ejb.gen.StatelessScheduledMethodTailFactory;
import com.caucho.java.JavaWriter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.HashMap;
import javax.enterprise.inject.spi.AnnotatedMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatelessScheduledMethodTailGenerator<X>
extends StatelessMethodTailGenerator<X> {
    private final String _methodName;

    public StatelessScheduledMethodTailGenerator(StatelessScheduledMethodTailFactory<X> factory, AnnotatedMethod<? super X> method) {
        super(factory, method);
        this._methodName = "__caucho_schedule_method_" + this._method.getJavaMember().getName();
    }

    @Override
    public void generateMethodPrologue(JavaWriter out, HashMap<String, Object> map) throws IOException {
        if (map.containsKey(this._methodName)) {
            return;
        }
        out.println("private java.lang.reflect.Method " + this._methodName + ";");
        map.put(this._methodName, true);
    }

    @Override
    public void generateProxyConstructor(JavaWriter out, HashMap<String, Object> map) throws IOException {
        Method javaMethod = this._method.getJavaMember();
        out.println("try {");
        out.pushDepth();
        out.println("java.lang.reflect.Method []methods = " + this.getBeanType().getJavaClass().getName() + ".class" + ".getDeclaredMethods();");
        out.println();
        out.println("for (java.lang.reflect.Method method : methods) {");
        out.pushDepth();
        out.println("if (method.getName().equals(\"" + javaMethod.getName() + "\")) {");
        out.pushDepth();
        out.println("Class<?> []parameterTypes = method.getParameterTypes();");
        out.println();
        Class<?>[] parameterTypes = javaMethod.getParameterTypes();
        out.println("if (parameterTypes.length != " + parameterTypes.length + ")");
        out.pushDepth();
        out.println("continue;");
        out.popDepth();
        for (int i = 0; i < parameterTypes.length; ++i) {
            Class<?> cl = parameterTypes[i];
            out.println("if (! parameterTypes[" + i + "].equals(" + cl.getName() + ".class))");
            out.pushDepth();
            out.println("continue;");
            out.popDepth();
        }
        out.println();
        out.println(this._methodName + " = method;");
        out.println(this._methodName + ".setAccessible(true);");
        out.println();
        out.println("break;");
        out.popDepth();
        out.println("}");
        out.popDepth();
        out.println("}");
        out.popDepth();
        out.println("}");
        out.println("catch (Exception e) {");
        out.pushDepth();
        out.println("throw new RuntimeException(\"Cannot find method \\\"" + javaMethod.getName() + "\\\"\", e);");
        out.popDepth();
        out.println("}");
        out.println();
        out.println("if (" + this._methodName + " == null)");
        out.pushDepth();
        out.println("throw new RuntimeException(\"Cannot find method \\\"" + javaMethod.getName() + "\\\"\");");
        out.popDepth();
    }

    @Override
    public void generateCall(JavaWriter out) throws IOException {
        Method javaMethod = this._method.getJavaMember();
        String instance = this._factory.getAspectBeanFactory().getBeanInstance();
        out.println();
        out.println("try {");
        out.pushDepth();
        out.print(this._methodName + ".invoke(" + instance);
        Class<?>[] types = javaMethod.getParameterTypes();
        for (int i = 0; i < types.length; ++i) {
            out.print(", ");
            out.print(" a" + i);
        }
        out.println(");");
        out.popDepth();
        out.println("}");
        out.println("catch (IllegalAccessException e) {");
        out.pushDepth();
        out.println("throw new RuntimeException(e);");
        out.popDepth();
        out.println("}");
        out.println("catch (java.lang.reflect.InvocationTargetException e) {");
        out.pushDepth();
        out.println("throw new RuntimeException(e);");
        out.popDepth();
        out.println("}");
    }
}

