/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.hessian;

import com.caucho.ejb.hessian.NameContextSkeleton;
import com.caucho.ejb.protocol.ProtocolContainer;
import com.caucho.ejb.protocol.Skeleton;
import com.caucho.ejb.server.AbstractEjbBeanManager;
import com.caucho.hessian.io.HessianRemoteResolver;
import com.caucho.hessian.server.HessianSkeleton;
import com.caucho.util.L10N;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.WeakHashMap;
import java.util.logging.Logger;

public class HessianProtocol
extends ProtocolContainer {
    private static final L10N L = new L10N(HessianProtocol.class);
    private static final Logger log = Logger.getLogger(HessianProtocol.class.getName());
    private HashMap<String, AbstractEjbBeanManager> _serverMap = new HashMap();
    private WeakHashMap<Class, HessianSkeleton> _skeletonMap = new WeakHashMap();
    private HessianRemoteResolver _resolver;

    public String getName() {
        return "hessian";
    }

    public void addServer(AbstractEjbBeanManager server) {
        log.finer(this + " add " + server);
        this._serverMap.put(server.getProtocolId(), server);
    }

    public void removeServer(AbstractEjbBeanManager server) {
        log.finer(this + " remove " + server);
        this._serverMap.remove(server.getProtocolId());
    }

    public Skeleton getSkeleton(String uri, String queryString) throws Exception {
        AbstractEjbBeanManager<?> server;
        String serverId = uri;
        String objectId = null;
        if (queryString != null) {
            int p = queryString.indexOf(61);
            objectId = p >= 0 ? queryString.substring(p + 1) : queryString;
        }
        if ((server = this._serverMap.get(serverId)) == null) {
            server = this.getProtocolManager().getServerByEJBName(serverId);
        }
        if (server == null) {
            ArrayList<String> children = this.getProtocolManager().getRemoteChildren(serverId);
            if (children != null && children.size() > 0) {
                return new NameContextSkeleton(this, serverId);
            }
            log.fine(this + " can't find server for " + serverId);
            return null;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HessianSkeleton getSkeleton(Class api, Class homeApi, Class remoteApi) throws Exception {
        WeakHashMap<Class, HessianSkeleton> weakHashMap = this._skeletonMap;
        synchronized (weakHashMap) {
            HessianSkeleton skel = this._skeletonMap.get(api);
            if (skel == null) {
                skel = new HessianSkeleton(api);
                skel.setHomeClass(homeApi);
                skel.setObjectClass(remoteApi);
                this._skeletonMap.put(api, skel);
            }
            return skel;
        }
    }
}

