/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.manager;

import com.caucho.config.ConfigException;
import com.caucho.config.inject.InjectManager;
import com.caucho.ejb.cfg.EjbConfigManager;
import com.caucho.ejb.cfg.EjbRootConfig;
import com.caucho.ejb.manager.EjbModule;
import com.caucho.ejb.manager.EjbScanClass;
import com.caucho.ejb.protocol.EjbProtocolManager;
import com.caucho.ejb.server.AbstractEjbBeanManager;
import com.caucho.ejb.util.AppExceptionItem;
import com.caucho.java.WorkDir;
import com.caucho.loader.Environment;
import com.caucho.loader.EnvironmentClassLoader;
import com.caucho.loader.EnvironmentListener;
import com.caucho.loader.EnvironmentLocal;
import com.caucho.loader.enhancer.ScanClass;
import com.caucho.loader.enhancer.ScanListener;
import com.caucho.util.CharBuffer;
import com.caucho.vfs.JarPath;
import com.caucho.vfs.Path;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.jms.ConnectionFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EjbManager
implements ScanListener,
EnvironmentListener {
    private static final Logger log = Logger.getLogger(EjbManager.class.getName());
    private static final EnvironmentLocal<EjbManager> _localContainer = new EnvironmentLocal();
    private static final EnvironmentLocal<Boolean> _localScanAll = new EnvironmentLocal();
    private ClassLoader _globalClassLoader;
    private final EnvironmentClassLoader _classLoader;
    private final ClassLoader _tempClassLoader;
    private final EjbManager _parentContainer;
    private final EjbConfigManager _configManager;
    private final EjbProtocolManager _protocolManager;
    private final HashSet<String> _ejbUrls = new HashSet();
    private InjectManager _cdiManager;
    private ArrayList<Path> _scannableRoots = null;
    private boolean _isAutoCompile = true;
    private Path _workDir;
    private ConnectionFactory _jmsConnectionFactory;
    private int _messageConsumerMax = 5;
    private final ArrayList<AbstractEjbBeanManager<?>> _serverList = new ArrayList();
    private final AtomicBoolean _isConfig = new AtomicBoolean();

    private EjbManager(ClassLoader loader) {
        this._parentContainer = _localContainer.get(loader);
        this._classLoader = Environment.getEnvironmentClassLoader(loader);
        this._tempClassLoader = this._classLoader.getNewTempClassLoader();
        _localContainer.set(this, this._classLoader);
        if (this._parentContainer != null) {
            this.copyContainerDefaults(this._parentContainer);
        }
        this._protocolManager = new EjbProtocolManager(this);
        this._configManager = new EjbConfigManager(this);
        this._cdiManager = InjectManager.getCurrent(this._classLoader);
        this._classLoader.addScanListener(this);
        Environment.addEnvironmentListener(this);
        EjbModule.create("default");
    }

    public static EjbManager create() {
        return EjbManager.create(Thread.currentThread().getContextClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EjbManager create(ClassLoader loader) {
        EnvironmentLocal<EjbManager> environmentLocal = _localContainer;
        synchronized (environmentLocal) {
            EjbManager container = _localContainer.getLevel(loader);
            if (container == null) {
                Boolean ejbManager = null;
                ejbManager = (Boolean)Environment.getAttribute("ejb.manager", loader);
                container = ejbManager == null || Boolean.TRUE.equals(ejbManager) ? new EjbManager(loader) : _localContainer.get(loader);
                _localContainer.set(container, loader);
            }
            return container;
        }
    }

    public static EjbManager getCurrent() {
        return EjbManager.getCurrent(Thread.currentThread().getContextClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EjbManager getCurrent(ClassLoader loader) {
        EnvironmentLocal<EjbManager> environmentLocal = _localContainer;
        synchronized (environmentLocal) {
            return _localContainer.get(loader);
        }
    }

    public static void setScanAll() {
        _localScanAll.set(true);
    }

    public void setGlobalClassLoader(ClassLoader globalClassLoader) {
        this._globalClassLoader = globalClassLoader;
    }

    public EnvironmentClassLoader getClassLoader() {
        return this._classLoader;
    }

    public ClassLoader getGlobalClassLoader() {
        if (this._globalClassLoader != null) {
            return this._globalClassLoader;
        }
        return this._classLoader;
    }

    public ClassLoader getIntrospectionClassLoader() {
        return this._tempClassLoader;
    }

    public EjbConfigManager getConfigManager() {
        return this._configManager;
    }

    public EjbManager getParent() {
        return this._parentContainer;
    }

    public EjbProtocolManager getProtocolManager() {
        return this._protocolManager;
    }

    public InjectManager getInjectManager() {
        return this._cdiManager;
    }

    public void setAutoCompile(boolean isAutoCompile) {
        this._isAutoCompile = isAutoCompile;
    }

    public boolean isAutoCompile() {
        return this._isAutoCompile;
    }

    public void setWorkDir(Path workDir) {
        this._workDir = workDir;
    }

    public Path getWorkDir() {
        if (this._workDir != null) {
            return this._workDir;
        }
        return WorkDir.getLocalWorkDir().lookup("ejb");
    }

    public void setJmsConnectionFactory(ConnectionFactory factory) {
        this._jmsConnectionFactory = factory;
    }

    public void setMessageConsumerMax(int consumerMax) {
        this._messageConsumerMax = consumerMax;
    }

    public int getMessageConsumerMax() {
        return this._messageConsumerMax;
    }

    private void copyContainerDefaults(EjbManager parent) {
        this._isAutoCompile = parent._isAutoCompile;
        this._jmsConnectionFactory = parent._jmsConnectionFactory;
        this._messageConsumerMax = parent._messageConsumerMax;
    }

    public boolean isConfiguredBean(Class<?> beanType) {
        return this._configManager.isConfiguredBean(beanType);
    }

    public <T> void createBean(AnnotatedType<T> type, InjectionTarget<T> injectionTarget) {
        this._configManager.addAnnotatedType(type, type, injectionTarget, "");
    }

    public void addServer(AbstractEjbBeanManager<?> server) {
        this._serverList.add(server);
        this.getProtocolManager().addServer(server);
    }

    public AbstractEjbBeanManager<?> getServerByEjbName(String name) {
        for (AbstractEjbBeanManager<?> server : this._serverList) {
            if (!server.getEJBName().equals(name)) continue;
            return server;
        }
        if (this._parentContainer != null) {
            return this._parentContainer.getServerByEjbName(name);
        }
        return null;
    }

    @Override
    public int getScanPriority() {
        return 1;
    }

    public void configureRootPath(Path root) {
        Path ejbJar;
        if (root.getURL().endsWith(".jar")) {
            root = JarPath.create(root);
        }
        if ((ejbJar = root.lookup("META-INF/ejb-jar.xml")).canRead()) {
            this.getConfigManager().configureRootPath(root);
        } else if (root.getURL().endsWith("WEB-INF/classes") && (ejbJar = root.lookup("../ejb-jar.xml")).canRead()) {
            this.getConfigManager().configureRootPath(root);
        }
        this._ejbUrls.add(root.getURL());
    }

    public void setScannableRoots(ArrayList<Path> roots) {
        this._scannableRoots = roots;
    }

    @Override
    public boolean isRootScannable(Path root, String packageRoot) {
        EjbRootConfig context;
        Path scanRoot = root;
        if (packageRoot != null) {
            scanRoot = scanRoot.lookup(packageRoot.replace('.', '/'));
        }
        if (this._scannableRoots == null) {
            if (!Boolean.TRUE.equals(_localScanAll.get()) && !scanRoot.lookup("META-INF/ejb-jar.xml").canRead()) {
                return false;
            }
            if (this._ejbUrls.contains(root.getURL())) {
                return false;
            }
        } else {
            Path path = scanRoot;
            if (root instanceof JarPath) {
                path = ((JarPath)root).getContainer();
            }
            if (!this._scannableRoots.contains(path)) {
                return false;
            }
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("EJB scanning '" + root + "'");
        }
        if ((context = this._configManager.createRootConfig(scanRoot)).isScanComplete()) {
            return false;
        }
        context.setScanComplete(true);
        return true;
    }

    @Override
    public ScanClass scanClass(Path root, String packageRoot, String className, int modifiers) {
        if (Modifier.isInterface(modifiers)) {
            return null;
        }
        return new EjbScanClass(root, className, this);
    }

    @Override
    public boolean isScanMatchAnnotation(CharBuffer annotationName) {
        if (annotationName.matches("javax.ejb.Stateless")) {
            return true;
        }
        if (annotationName.matches("javax.ejb.Singleton")) {
            return true;
        }
        if (annotationName.matches("javax.ejb.Stateful")) {
            return true;
        }
        if (annotationName.matches("javax.ejb.MessageDriven")) {
            return true;
        }
        return annotationName.matches("javax.annotation.ManagedBean");
    }

    @Override
    public void classMatchEvent(EnvironmentClassLoader loader, Path root, String className) {
        EjbRootConfig config = this._configManager.createRootConfig(root);
        config.addClassName(className);
    }

    void addScanClass(Path root, String className) {
        EjbRootConfig config = this._configManager.createRootConfig(root);
        config.addClassName(className);
    }

    public AppExceptionItem getSystemException(Class<?> exceptionClass) {
        return this._configManager.getApplicationException(exceptionClass, true);
    }

    public AppExceptionItem getApplicationException(Class<?> exceptionClass) {
        return this._configManager.getApplicationException(exceptionClass, false);
    }

    public void init() {
    }

    private void config() {
        if (this._isConfig.getAndSet(true)) {
            return;
        }
        this._configManager.start();
    }

    private void bind() {
        this.config();
        this._cdiManager.bind();
        for (AbstractEjbBeanManager<?> manager : this.sortManagers()) {
            manager.bind();
        }
    }

    private ArrayList<AbstractEjbBeanManager<?>> sortManagers() {
        AbstractEjbBeanManager<?> server;
        ArrayList serverList = new ArrayList(this._serverList);
        ArrayList bindList = new ArrayList();
        while ((server = this.nextBindServer(serverList, bindList)) != null) {
        }
        return bindList;
    }

    private AbstractEjbBeanManager<?> nextBindServer(ArrayList<AbstractEjbBeanManager<?>> serverList, ArrayList<AbstractEjbBeanManager<?>> bindList) {
        if (serverList.size() == 0) {
            return null;
        }
        for (AbstractEjbBeanManager<?> server : serverList) {
            if (!server.isDependValid(bindList)) continue;
            serverList.remove(server);
            bindList.add(server);
            return server;
        }
        AbstractEjbBeanManager<?> server = serverList.remove(0);
        bindList.add(server);
        return server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void start() throws ConfigException {
        try {
            this.bind();
            Thread thread = Thread.currentThread();
            ClassLoader oldLoader = thread.getContextClassLoader();
            for (AbstractEjbBeanManager<?> server : this.sortManagers()) {
                Object var6_7;
                try {
                    thread.setContextClassLoader(server.getClassLoader());
                    server.start();
                    var6_7 = null;
                    thread.setContextClassLoader(oldLoader);
                }
                catch (Throwable throwable) {
                    var6_7 = null;
                    thread.setContextClassLoader(oldLoader);
                    throw throwable;
                    return;
                }
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw ConfigException.create(e);
        }
    }

    public void destroy() {
        try {
            ArrayList servers = new ArrayList(this._serverList);
            this._serverList.clear();
            Collections.sort(servers, new ServerCmp());
            for (AbstractEjbBeanManager<?> server : servers) {
                try {
                    this.getProtocolManager().removeServer(server);
                }
                catch (Throwable e) {
                    log.log(Level.WARNING, e.toString(), e);
                }
            }
            for (AbstractEjbBeanManager<?> server : servers) {
                try {
                    server.destroy();
                }
                catch (Throwable e) {
                    log.log(Level.WARNING, e.toString(), e);
                }
            }
        }
        catch (Throwable e) {
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    @Override
    public void environmentConfigure(EnvironmentClassLoader loader) {
        this.config();
    }

    @Override
    public void environmentBind(EnvironmentClassLoader loader) {
        this.bind();
    }

    @Override
    public void environmentStart(EnvironmentClassLoader loader) {
        this.start();
    }

    @Override
    public void environmentStop(EnvironmentClassLoader loader) {
        this.destroy();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._classLoader + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ServerCmp
    implements Comparator<AbstractEjbBeanManager<?>> {
        ServerCmp() {
        }

        @Override
        public int compare(AbstractEjbBeanManager<?> a, AbstractEjbBeanManager<?> b) {
            return a.getEJBName().compareTo(b.getEJBName());
        }
    }
}

