/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.manager;

import com.caucho.inject.Module;
import com.caucho.loader.EnvironmentLocal;
import com.caucho.naming.Jndi;
import java.util.logging.Level;
import java.util.logging.Logger;

@Module
public class EjbModule {
    private static final Logger log = Logger.getLogger(EjbModule.class.getName());
    private static final EnvironmentLocal<EjbModule> _localModule = new EnvironmentLocal();
    private final String _moduleName;

    private EjbModule(String name) {
        this._moduleName = name;
    }

    public static EjbModule getCurrent() {
        return _localModule.get();
    }

    public static EjbModule create(String name) {
        EjbModule module = _localModule.getLevel();
        if (module == null) {
            module = new EjbModule(name);
            _localModule.set(module);
        }
        return module;
    }

    public static EjbModule replace(String name) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        return EjbModule.replace(name, loader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EjbModule replace(String name, ClassLoader loader) {
        EjbModule module = new EjbModule(name);
        _localModule.set(module, loader);
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            try {
                thread.setContextClassLoader(loader);
                Jndi.bindDeep("java:module/ModuleName", name);
            }
            catch (Exception e) {
                log.log(Level.WARNING, e.toString(), e);
                Object var7_6 = null;
                thread.setContextClassLoader(oldLoader);
            }
            Object var7_5 = null;
            thread.setContextClassLoader(oldLoader);
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            thread.setContextClassLoader(oldLoader);
            throw throwable;
        }
        return module;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setAppName(String name, ClassLoader loader) {
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            try {
                thread.setContextClassLoader(loader);
                Jndi.bindDeep("java:app/AppName", name);
            }
            catch (Exception e) {
                log.log(Level.WARNING, e.toString(), e);
                Object var6_5 = null;
                thread.setContextClassLoader(oldLoader);
            }
            Object var6_4 = null;
            thread.setContextClassLoader(oldLoader);
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            thread.setContextClassLoader(oldLoader);
            throw throwable;
        }
    }

    public String getModuleName() {
        return this._moduleName;
    }
}

