/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.xa;

import com.caucho.config.program.ConfigProgram;
import com.caucho.ejb.util.XAManager;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.transaction.Transaction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class XaInterceptor
extends ConfigProgram {
    private static final Object[] NULL_ARGS = new Object[0];
    private static final XAManager _xa = new XAManager();
    private Method _javaMethod;

    protected XaInterceptor(AnnotatedMethod<?> method) {
        this._javaMethod = method.getJavaMember();
    }

    public static ConfigProgram create(AnnotatedMethod<?> method) {
        TransactionAttribute xaAttr = method.getAnnotation(TransactionAttribute.class);
        TransactionAttribute xaClassAttr = method.getDeclaringType().getAnnotation(TransactionAttribute.class);
        TransactionAttributeType xaType = null;
        if (xaClassAttr != null) {
            xaType = xaClassAttr.value();
        }
        if (xaAttr != null) {
            xaType = xaAttr.value();
        }
        if (xaType == null) {
            return null;
        }
        switch (xaType) {
            case REQUIRED: {
                return new RequiresInterceptor(method);
            }
        }
        return null;
    }

    protected void invokeMethod(Object instance, Object[] args) {
        try {
            this._javaMethod.invoke(instance, args);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(this._javaMethod.getName() + ": " + e, e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(this._javaMethod.getName() + ": " + e, e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(this._javaMethod.getName() + ": " + e.getCause(), e.getCause());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class RequiresInterceptor
    extends XaInterceptor {
        RequiresInterceptor(AnnotatedMethod<?> method) {
            super(method);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> void inject(T bean, CreationalContext<T> createContext) {
            Transaction xa = null;
            boolean isXAValid = false;
            try {
                try {
                    xa = _xa.beginRequired();
                    this.invokeMethod(bean, NULL_ARGS);
                    isXAValid = true;
                }
                catch (RuntimeException e) {
                    isXAValid = true;
                    if (_xa.systemException(e)) {
                        _xa.rethrowEjbException(e, xa != null);
                    }
                    Object var7_6 = null;
                    if (!isXAValid) {
                        _xa.markRollback();
                    }
                    if (xa == null) {
                        _xa.commit();
                    }
                }
                Object var7_5 = null;
                if (!isXAValid) {
                    _xa.markRollback();
                }
                if (xa == null) {
                    _xa.commit();
                }
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (!isXAValid) {
                    _xa.markRollback();
                }
                if (xa == null) {
                    _xa.commit();
                }
                throw throwable;
            }
        }
    }
}

