/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.el;

import com.caucho.el.AbstractBooleanExpr;
import com.caucho.el.EqExpr;
import com.caucho.el.Expr;
import com.caucho.el.GeExpr;
import com.caucho.el.GtExpr;
import com.caucho.el.LeExpr;
import com.caucho.el.LtExpr;
import com.caucho.el.MatchesExpr;
import com.caucho.el.NeExpr;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import javax.el.ELContext;
import javax.el.ELException;

public class CmpExpr
extends AbstractBooleanExpr {
    private int _op;
    private Expr _left;
    private Expr _right;

    private CmpExpr(int op, Expr left, Expr right) {
        this._op = op;
        this._left = left;
        this._right = right;
    }

    static Expr create(int op, Expr left, Expr right) {
        switch (op) {
            case 8: {
                return new LtExpr(left, right);
            }
            case 9: {
                return new LeExpr(left, right);
            }
            case 10: {
                return new GtExpr(left, right);
            }
            case 11: {
                return new GeExpr(left, right);
            }
            case 6: {
                return new EqExpr(left, right);
            }
            case 7: {
                return new NeExpr(left, right);
            }
            case 16: {
                return new MatchesExpr(left, right);
            }
        }
        return new CmpExpr(op, left, right);
    }

    public boolean isConstant() {
        return this._left.isConstant() && this._right.isConstant();
    }

    public boolean evalBoolean(ELContext env) throws ELException {
        double b;
        double a;
        Object aObj = this._left.getValue(env);
        Object bObj = this._right.getValue(env);
        if (aObj == null || bObj == null) {
            return false;
        }
        if (aObj == bObj) {
            return this._op == 9 || this._op == 11;
        }
        if (aObj instanceof Double || aObj instanceof Float || bObj instanceof Double || bObj instanceof Float) {
            a = CmpExpr.toDouble(aObj, env);
            b = CmpExpr.toDouble(bObj, env);
            switch (this._op) {
                case 8: {
                    return a < b;
                }
                case 9: {
                    return a <= b;
                }
                case 10: {
                    return a > b;
                }
                case 11: {
                    return a >= b;
                }
            }
        }
        if (aObj instanceof Number || bObj instanceof Number) {
            a = CmpExpr.toDouble(aObj, env);
            b = CmpExpr.toDouble(bObj, env);
            switch (this._op) {
                case 8: {
                    return a < b;
                }
                case 9: {
                    return a <= b;
                }
                case 10: {
                    return a > b;
                }
                case 11: {
                    return a >= b;
                }
            }
        }
        if (aObj instanceof String || bObj instanceof String) {
            String a2 = CmpExpr.toString(aObj, env);
            String b2 = CmpExpr.toString(bObj, env);
            int cmp = a2.compareTo(b2);
            switch (this._op) {
                case 8: {
                    return cmp < 0;
                }
                case 9: {
                    return cmp <= 0;
                }
                case 10: {
                    return cmp > 0;
                }
                case 11: {
                    return cmp >= 0;
                }
            }
        }
        if (aObj instanceof Comparable) {
            int cmp = ((Comparable)aObj).compareTo(bObj);
            switch (this._op) {
                case 8: {
                    return cmp < 0;
                }
                case 9: {
                    return cmp <= 0;
                }
                case 10: {
                    return cmp > 0;
                }
                case 11: {
                    return cmp >= 0;
                }
            }
        }
        if (bObj instanceof Comparable) {
            int cmp = ((Comparable)bObj).compareTo(aObj);
            switch (this._op) {
                case 8: {
                    return cmp > 0;
                }
                case 9: {
                    return cmp >= 0;
                }
                case 10: {
                    return cmp < 0;
                }
                case 11: {
                    return cmp <= 0;
                }
            }
        }
        ELException e = new ELException(L.l("can't compare {0} and {1}.", aObj, bObj));
        CmpExpr.error(e, env);
        return false;
    }

    public void printCreate(WriteStream os) throws IOException {
        os.print("new com.caucho.el.CmpExpr(");
        os.print(this._op + ", ");
        this._left.printCreate(os);
        os.print(", ");
        this._right.printCreate(os);
        os.print(")");
    }

    public boolean equals(Object o) {
        if (!(o instanceof CmpExpr)) {
            return false;
        }
        CmpExpr expr = (CmpExpr)o;
        return this._op == expr._op && this._left.equals(expr._left) && this._right.equals(expr._right);
    }

    public String toString() {
        String op;
        switch (this._op) {
            case 8: {
                op = " lt";
                break;
            }
            case 9: {
                op = " le ";
                break;
            }
            case 10: {
                op = " gt ";
                break;
            }
            case 11: {
                op = " ge ";
                break;
            }
            default: {
                op = " unknown(" + this._op + ") ";
            }
        }
        return "(" + this._left + op + this._right + ")";
    }
}

