/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.el;

import com.caucho.config.types.Period;
import com.caucho.el.ArrayResolverExpr;
import com.caucho.el.ExprEnv;
import com.caucho.el.FunctionExpr;
import com.caucho.el.StringLiteral;
import com.caucho.util.BeanUtil;
import com.caucho.util.IntMap;
import com.caucho.util.L10N;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.MethodInfo;
import javax.el.PropertyNotFoundException;
import javax.el.PropertyNotWritableException;
import javax.el.ValueExpression;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Expr
extends ValueExpression {
    protected static final Logger log = Logger.getLogger(Expr.class.getName());
    protected static final L10N L = new L10N(Expr.class);
    private static final BigDecimal BIG_DECIMAL_ZERO = new BigDecimal("0");
    private static final BigInteger BIG_INTEGER_ZERO = new BigInteger("0");
    private static final HashMap<Class<?>, CoerceType> _coerceMap = new HashMap();
    static final int ADD = 1;
    static final int SUB = 2;
    static final int MUL = 3;
    static final int DIV = 4;
    static final int MOD = 5;
    static final int EQ = 6;
    static final int NE = 7;
    static final int LT = 8;
    static final int LE = 9;
    static final int GT = 10;
    static final int GE = 11;
    static final int AND = 12;
    static final int OR = 13;
    static final int NOT = 14;
    static final int MINUS = 15;
    static final int EMPTY = 16;
    static final int COND_BINARY = 17;
    static final int OBJECT = 0;
    static final int BOOLEAN = 1;
    static final int BYTE = 2;
    static final int SHORT = 3;
    static final int INT = 4;
    static final int LONG = 5;
    static final int FLOAT = 6;
    static final int DOUBLE = 7;
    static final int BOOLEAN_OBJ = 8;
    static final int BYTE_OBJ = 9;
    static final int SHORT_OBJ = 10;
    static final int INT_OBJ = 11;
    static final int LONG_OBJ = 12;
    static final int FLOAT_OBJ = 13;
    static final int DOUBLE_OBJ = 14;
    static final int STRING = 15;
    static final int MATCHES = 16;
    static final IntMap _typeMap = new IntMap();

    public boolean isConstant() {
        return false;
    }

    @Override
    public boolean isReadOnly(ELContext env) {
        return true;
    }

    @Override
    public boolean isLiteralText() {
        return false;
    }

    public Expr createField(Expr field) {
        return new ArrayResolverExpr(this, field);
    }

    public Expr createField(String field) {
        return this.createField(new StringLiteral(field));
    }

    public Expr createMethod(Expr[] args) {
        return new FunctionExpr(this, args);
    }

    @Override
    public abstract Object getValue(ELContext var1) throws ELException;

    public MethodInfo getMethodInfo(ELContext env, Class<?> returnType, Class<?>[] argTypes) throws ELException {
        throw new ELException(L.l("'{0}' is an illegal method expression." + this.getClass(), (Object)this.toString()));
    }

    public Object invoke(ELContext env, Class<?>[] argTypes, Object[] args) throws ELException {
        throw new ELException(L.l("'{0}' is an illegal method expression on {1}", (Object)this.toString(), (Object)this.getClass().getName()));
    }

    public final Object evalObject(ELContext env) throws ELException {
        return this.getValue(env);
    }

    public boolean evalBoolean(ELContext env) throws ELException {
        return Expr.toBoolean(this.getValue(env), env);
    }

    public double evalDouble(ELContext env) throws ELException {
        return Expr.toDouble(this.getValue(env), env);
    }

    public long evalLong(ELContext env) throws ELException {
        return Expr.toLong(this.getValue(env), env);
    }

    public String evalString(ELContext env) throws ELException {
        return Expr.toString(this.getValue(env), env);
    }

    public String evalStringWithNull(ELContext env) throws ELException {
        return Expr.toStringWithNull(this.getValue(env), env);
    }

    public char evalCharacter(ELContext env) throws ELException {
        return Expr.toCharacter(this.getValue(env), env);
    }

    public long evalPeriod(ELContext env) throws ELException {
        try {
            Object obj = this.getValue(env);
            if (obj instanceof Number) {
                return 1000L * ((Number)obj).longValue();
            }
            return Period.toPeriod(Expr.toString(obj, env));
        }
        catch (Exception e) {
            throw new ELException(e.getMessage());
        }
    }

    public BigInteger evalBigInteger(ELContext env) throws ELException {
        return Expr.toBigInteger(this.getValue(env), env);
    }

    public BigDecimal evalBigDecimal(ELContext env) throws ELException {
        return Expr.toBigDecimal(this.getValue(env), env);
    }

    @Override
    public void setValue(ELContext env, Object value) throws PropertyNotFoundException, PropertyNotWritableException, ELException {
        throw new PropertyNotWritableException(this.getClass().getName() + ": " + this.toString());
    }

    public boolean print(WriteStream out, ELContext env, boolean escapeXml) throws IOException, ELException {
        Object obj = this.getValue(env);
        if (obj == null) {
            return true;
        }
        if (escapeXml) {
            Expr.toStreamEscaped(out, obj);
            return false;
        }
        Expr.toStream(out, obj);
        return false;
    }

    public boolean print(JspWriter out, ELContext env, boolean escapeXml) throws IOException, ELException {
        Object obj = this.getValue(env);
        if (obj == null) {
            return true;
        }
        if (escapeXml) {
            Expr.toStreamEscaped((Writer)out, obj);
            return false;
        }
        Expr.toStream(out, obj);
        return false;
    }

    public void printCreate(WriteStream os) throws IOException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public String getExpressionString() {
        return this.toString();
    }

    @Override
    public Class<?> getExpectedType() {
        return Object.class;
    }

    @Override
    public Class<?> getType(ELContext context) throws PropertyNotFoundException, ELException {
        Object value = this.getValue(context);
        if (value == null) {
            return null;
        }
        return value.getClass();
    }

    public static boolean isDouble(Object o) {
        if (o instanceof Double) {
            return true;
        }
        if (o instanceof Float) {
            return true;
        }
        if (!(o instanceof String)) {
            return false;
        }
        String s = (String)o;
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char ch = s.charAt(i);
            if (ch != '.' && ch != 'e' && ch != 'E') continue;
            return true;
        }
        return false;
    }

    public static String toStringWithNull(Object value, ELContext env) {
        if (value == null || value instanceof String) {
            return (String)value;
        }
        return value.toString();
    }

    public static String toString(Object value, ELContext env) {
        if (value == null) {
            return "";
        }
        if (value instanceof String) {
            return (String)value;
        }
        return value.toString();
    }

    public static String toString(long value, ELContext env) {
        return String.valueOf(value);
    }

    public static String toString(double value, ELContext env) {
        return String.valueOf(value);
    }

    public static String toString(boolean value, ELContext env) {
        return String.valueOf(value);
    }

    public static String toString(char value, ELContext env) {
        return String.valueOf(value);
    }

    public static char toCharacter(Object value, ELContext env) throws ELException {
        if (value == null) {
            return '\u0000';
        }
        if (value instanceof Character) {
            return ((Character)value).charValue();
        }
        if (value instanceof String) {
            String s = (String)value;
            if (s == null || s.length() == 0) {
                return '\u0000';
            }
            return s.charAt(0);
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            return (char)number.intValue();
        }
        if (value instanceof Boolean) {
            ELException e = new ELException(L.l("can't convert {0} to character.", (Object)value.getClass().getName()));
            throw e;
        }
        return (char)Expr.toLong(value, env);
    }

    public static boolean toBoolean(Object value, ELContext env) throws ELException {
        if (value == null || value.equals("")) {
            return false;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return value.equals("true") || value.equals("yes");
        }
        ELException e = new ELException(L.l("can't convert {0} to boolean.", (Object)value.getClass().getName()));
        throw e;
    }

    public static double toDouble(Object value, ELContext env) throws ELException {
        try {
            if (value == null) {
                return 0.0;
            }
            if (value instanceof Number) {
                double dValue = ((Number)value).doubleValue();
                if (Double.isNaN(dValue)) {
                    return 0.0;
                }
                return dValue;
            }
            if (value.equals("")) {
                return 0.0;
            }
            if (value instanceof String) {
                double dValue = Double.parseDouble((String)value);
                if (Double.isNaN(dValue)) {
                    return 0.0;
                }
                return dValue;
            }
            if (value instanceof Character) {
                return ((Character)value).charValue();
            }
            ELException e = new ELException(L.l("can't convert {0} to double.", (Object)value.getClass().getName()));
            throw e;
        }
        catch (NumberFormatException e) {
            throw new ELException(L.l("can't convert '{0}' to double.", value));
        }
    }

    public static BigDecimal toBigDecimal(Object value, ELContext env) throws ELException {
        if (value == null) {
            return BIG_DECIMAL_ZERO;
        }
        if (value instanceof BigDecimal) {
            return (BigDecimal)value;
        }
        if (value instanceof Number) {
            double dValue = ((Number)value).doubleValue();
            return new BigDecimal(dValue);
        }
        if (value.equals("")) {
            return BIG_DECIMAL_ZERO;
        }
        if (value instanceof String) {
            return new BigDecimal((String)value);
        }
        if (value instanceof Character) {
            return new BigDecimal(((Character)value).charValue());
        }
        ELException e = new ELException(L.l("can't convert {0} to BigDecimal.", (Object)value.getClass().getName()));
        Expr.error(e, env);
        return BIG_DECIMAL_ZERO;
    }

    public static BigInteger toBigInteger(Object value, ELContext env) throws ELException {
        if (value == null) {
            return BIG_INTEGER_ZERO;
        }
        if (value instanceof BigInteger) {
            return (BigInteger)value;
        }
        if (value instanceof Number) {
            return new BigDecimal(value.toString()).toBigInteger();
        }
        if (value.equals("")) {
            return BIG_INTEGER_ZERO;
        }
        if (value instanceof String) {
            return new BigInteger((String)value);
        }
        if (value instanceof Character) {
            return new BigInteger(String.valueOf((int)((Character)value).charValue()));
        }
        ELException e = new ELException(L.l("can't convert {0} to BigInteger.", (Object)value.getClass().getName()));
        Expr.error(e, env);
        return BIG_INTEGER_ZERO;
    }

    public static long toLong(Object value, ELContext env) throws ELException {
        if (value == null) {
            return 0L;
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value.equals("")) {
            return 0L;
        }
        if (value instanceof String) {
            try {
                String string = (String)value;
                return Long.parseLong(string);
            }
            catch (Exception e) {
                throw new ELException(e);
            }
        }
        if (value instanceof Character) {
            return ((Character)value).charValue();
        }
        ELException e = new ELException(L.l("can't convert {0} to long.", (Object)value.getClass().getName()));
        throw e;
    }

    public static boolean toStream(JspWriter out, Object value, boolean isEscaped) throws IOException {
        if (value == null) {
            return true;
        }
        if (isEscaped) {
            Expr.toStreamEscaped((Writer)out, value);
        } else {
            Expr.toStream(out, value);
        }
        return false;
    }

    public static void toStream(WriteStream out, Object value) throws IOException {
        if (value == null) {
            return;
        }
        if (value instanceof String) {
            out.print((String)value);
        } else if (value instanceof Reader) {
            out.writeStream((Reader)value);
        } else {
            out.print(value.toString());
        }
    }

    public static void toStream(JspWriter out, Object value) throws IOException {
        if (value == null) {
            return;
        }
        if (value instanceof String) {
            out.print((String)value);
        } else if (value instanceof Reader) {
            int ch;
            Reader reader = (Reader)value;
            while ((ch = reader.read()) > 0) {
                out.print((char)ch);
            }
        } else {
            out.print(value.toString());
        }
    }

    public static void printEscapedString(WriteStream os, String string) throws IOException {
        int length = string.length();
        block6: for (int i = 0; i < length; ++i) {
            char ch = string.charAt(i);
            switch (ch) {
                case '\\': {
                    os.print("\\\\");
                    continue block6;
                }
                case '\n': {
                    os.print("\\n");
                    continue block6;
                }
                case '\r': {
                    os.print("\\r");
                    continue block6;
                }
                case '\"': {
                    os.print("\\\"");
                    continue block6;
                }
                default: {
                    os.print(ch);
                }
            }
        }
    }

    public static void toStreamEscaped(Writer out, Object value) throws IOException {
        if (value == null) {
            return;
        }
        if (value instanceof Reader) {
            Expr.toStreamEscaped(out, (Reader)value);
            return;
        }
        String string = value.toString();
        int length = string.length();
        block7: for (int i = 0; i < length; ++i) {
            char ch = string.charAt(i);
            switch (ch) {
                case '<': {
                    out.write("&lt;");
                    continue block7;
                }
                case '>': {
                    out.write("&gt;");
                    continue block7;
                }
                case '&': {
                    out.write("&amp;");
                    continue block7;
                }
                case '\'': {
                    out.write("&#039;");
                    continue block7;
                }
                case '\"': {
                    out.write("&#034;");
                    continue block7;
                }
                default: {
                    out.write(ch);
                }
            }
        }
    }

    public static void toStreamEscaped(WriteStream out, Object value) throws IOException {
        if (value == null) {
            return;
        }
        String string = value.toString();
        int length = string.length();
        block7: for (int i = 0; i < length; ++i) {
            char ch = string.charAt(i);
            switch (ch) {
                case '<': {
                    out.print("&lt;");
                    continue block7;
                }
                case '>': {
                    out.print("&gt;");
                    continue block7;
                }
                case '&': {
                    out.print("&amp;");
                    continue block7;
                }
                case '\'': {
                    out.print("&#039;");
                    continue block7;
                }
                case '\"': {
                    out.print("&#034;");
                    continue block7;
                }
                default: {
                    out.print(ch);
                }
            }
        }
    }

    public static void toStreamEscaped(Writer out, Reader in) throws IOException {
        int ch;
        if (in == null) {
            return;
        }
        block7: while ((ch = in.read()) >= 0) {
            switch (ch) {
                case 60: {
                    out.write("&lt;");
                    continue block7;
                }
                case 62: {
                    out.write("&gt;");
                    continue block7;
                }
                case 38: {
                    out.write("&amp;");
                    continue block7;
                }
                case 39: {
                    out.write("&#039;");
                    continue block7;
                }
                case 34: {
                    out.write("&#034;");
                    continue block7;
                }
            }
            out.write((char)ch);
        }
    }

    public static Class<?> toClass(Object value, ELContext env) throws ELException {
        if (value == null) {
            return null;
        }
        if (value instanceof Class) {
            return (Class)value;
        }
        if (value instanceof String) {
            try {
                Thread thread = Thread.currentThread();
                ClassLoader loader = thread.getContextClassLoader();
                return Class.forName((String)value, false, loader);
            }
            catch (ClassNotFoundException e) {
                Expr.error(e, env);
                return null;
            }
        }
        ELException e = new ELException(L.l("can't convert {0} to Class.", (Object)value.getClass().getName()));
        Expr.error(e, env);
        return null;
    }

    public static Object toEnum(Object obj, Class<? extends Enum> enumType) {
        if (obj == null) {
            return null;
        }
        Class<?> objClass = obj.getClass();
        if (objClass.equals(enumType)) {
            return obj;
        }
        if (obj.getClass().equals(String.class) && "".equals(obj)) {
            return null;
        }
        try {
            return Enum.valueOf(enumType, obj.toString());
        }
        catch (IllegalArgumentException e) {
            throw new ELException(L.l("Unable convert '{0}' to '{1}'", (Object)obj.toString(), (Object)enumType.getName()));
        }
    }

    public static void printEscaped(WriteStream os, ReadStream is) throws IOException {
        int ch;
        block6: while ((ch = is.readChar()) >= 0) {
            switch (ch) {
                case 92: {
                    os.print("\\\\");
                    continue block6;
                }
                case 10: {
                    os.print("\\n");
                    continue block6;
                }
                case 13: {
                    os.print("\\r");
                    continue block6;
                }
                case 34: {
                    os.print("\\\"");
                    continue block6;
                }
            }
            os.print((char)ch);
        }
    }

    public static void setProperty(Object target, String property, Object value) throws ELException, JspException {
        if (target instanceof Map) {
            Map map = (Map)target;
            if (value != null) {
                map.put(property, value);
            } else {
                map.remove(property);
            }
        } else {
            if (target != null) {
                Method method = null;
                try {
                    method = BeanUtil.getSetMethod(target.getClass(), property);
                }
                catch (Exception e) {
                    throw new JspException(e);
                }
                if (method == null) {
                    throw new JspException(L.l("can't find property `{0}' in `{1}'", (Object)property, (Object)target.getClass()));
                }
                Class<?> type = method.getParameterTypes()[0];
                try {
                    int code = _typeMap.get(type);
                    switch (code) {
                        case 1: {
                            value = Expr.toBoolean(value, null) ? Boolean.TRUE : Boolean.FALSE;
                            break;
                        }
                        case 2: {
                            value = new Byte((byte)Expr.toLong(value, null));
                            break;
                        }
                        case 3: {
                            value = new Short((short)Expr.toLong(value, null));
                            break;
                        }
                        case 4: {
                            value = new Integer((int)Expr.toLong(value, null));
                            break;
                        }
                        case 5: {
                            value = new Long(Expr.toLong(value, null));
                            break;
                        }
                        case 6: {
                            value = new Float((float)Expr.toDouble(value, null));
                            break;
                        }
                        case 7: {
                            value = new Double(Expr.toDouble(value, null));
                            break;
                        }
                        case 8: {
                            if (value == null) break;
                            value = Expr.toBoolean(value, null) ? Boolean.TRUE : Boolean.FALSE;
                            break;
                        }
                        case 9: {
                            if (value == null) break;
                            value = new Byte((byte)Expr.toLong(value, null));
                            break;
                        }
                        case 10: {
                            if (value == null) break;
                            value = new Short((short)Expr.toLong(value, null));
                            break;
                        }
                        case 11: {
                            if (value == null) break;
                            value = new Integer((int)Expr.toLong(value, null));
                            break;
                        }
                        case 12: {
                            if (value == null) break;
                            value = new Long(Expr.toLong(value, null));
                            break;
                        }
                        case 13: {
                            if (value == null) break;
                            value = new Float((float)Expr.toDouble(value, null));
                            break;
                        }
                        case 14: {
                            if (value == null) break;
                            value = new Double(Expr.toDouble(value, null));
                            break;
                        }
                        case 15: {
                            if (value == null) break;
                            value = String.valueOf(value);
                            break;
                        }
                    }
                    method.invoke(target, value);
                }
                catch (Exception e) {
                    throw new JspException(e);
                }
            }
            throw new JspException(L.l("null is an invalid c:set target value."));
        }
    }

    protected static boolean isDoubleString(Object obj) {
        if (!(obj instanceof String)) {
            return false;
        }
        String s = (String)obj;
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char ch = s.charAt(i);
            if (ch != '.' && ch != 'e' && ch != 'E') continue;
            return true;
        }
        return false;
    }

    public static Object coerceToType(Object obj, Class<?> targetType) throws ELException {
        if (targetType == null) {
            return obj;
        }
        CoerceType type = _coerceMap.get(targetType);
        if (type != null) {
            switch (type) {
                case BOOLEAN: {
                    return Expr.toBoolean(obj, null) ? Boolean.TRUE : Boolean.FALSE;
                }
                case CHARACTER: {
                    return Character.valueOf(Expr.toCharacter(obj, null));
                }
                case BYTE: {
                    return new Byte((byte)Expr.toLong(obj, null));
                }
                case SHORT: {
                    return new Short((short)Expr.toLong(obj, null));
                }
                case INTEGER: {
                    return new Integer((int)Expr.toLong(obj, null));
                }
                case LONG: {
                    return new Long(Expr.toLong(obj, null));
                }
                case FLOAT: {
                    return new Float((float)Expr.toDouble(obj, null));
                }
                case DOUBLE: {
                    return new Double(Expr.toDouble(obj, null));
                }
                case STRING: {
                    if (obj == null) {
                        return "";
                    }
                    return obj.toString();
                }
                case BIG_DECIMAL: {
                    return Expr.toBigDecimal(obj, null);
                }
                case BIG_INTEGER: {
                    return Expr.toBigInteger(obj, null);
                }
                case CLASS: {
                    return Expr.toClass(obj, null);
                }
                case OBJECT: {
                    return obj;
                }
                case VOID: {
                    return null;
                }
            }
        } else {
            if (targetType.isEnum()) {
                return Expr.toEnum(obj, targetType);
            }
            if (obj == null) {
                return null;
            }
            if (targetType.isAssignableFrom(obj.getClass())) {
                return obj;
            }
        }
        throw new ELException(L.l("unable to convert {0} to type {1}", obj, (Object)targetType));
    }

    public static Object error(Throwable e, ELContext env) throws ELException {
        if (e instanceof ELException) {
            throw (ELException)e;
        }
        if (env == null) {
            throw new ELException(e);
        }
        if (env instanceof ExprEnv && ((ExprEnv)((Object)env)).isIgnoreException()) {
            log.log(Level.FINE, e.toString(), e);
            return null;
        }
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        throw new ELException(e);
    }

    @Override
    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Expr)) {
            return false;
        }
        return this.toString().equals(o.toString());
    }

    public abstract String toString();

    public static Object invocationError(Throwable e) throws ELException {
        if (e instanceof InvocationTargetException && e.getCause() != null) {
            e = e.getCause();
        }
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        if (e instanceof Error) {
            throw (Error)e;
        }
        throw new ELException(e);
    }

    static {
        _coerceMap.put(Boolean.TYPE, CoerceType.BOOLEAN);
        _coerceMap.put(Boolean.class, CoerceType.BOOLEAN);
        _coerceMap.put(Byte.TYPE, CoerceType.BYTE);
        _coerceMap.put(Byte.class, CoerceType.BYTE);
        _coerceMap.put(Short.TYPE, CoerceType.SHORT);
        _coerceMap.put(Short.class, CoerceType.SHORT);
        _coerceMap.put(Integer.TYPE, CoerceType.INTEGER);
        _coerceMap.put(Integer.class, CoerceType.INTEGER);
        _coerceMap.put(Long.TYPE, CoerceType.LONG);
        _coerceMap.put(Long.class, CoerceType.LONG);
        _coerceMap.put(Float.TYPE, CoerceType.FLOAT);
        _coerceMap.put(Float.class, CoerceType.FLOAT);
        _coerceMap.put(Double.TYPE, CoerceType.DOUBLE);
        _coerceMap.put(Double.class, CoerceType.DOUBLE);
        _coerceMap.put(Character.TYPE, CoerceType.CHARACTER);
        _coerceMap.put(Character.class, CoerceType.CHARACTER);
        _coerceMap.put(String.class, CoerceType.STRING);
        _coerceMap.put(BigDecimal.class, CoerceType.BIG_DECIMAL);
        _coerceMap.put(BigInteger.class, CoerceType.BIG_INTEGER);
        _coerceMap.put(Void.TYPE, CoerceType.VOID);
        _coerceMap.put(Object.class, CoerceType.OBJECT);
        _coerceMap.put(Class.class, CoerceType.CLASS);
        _typeMap.put(Boolean.TYPE, 1);
        _typeMap.put(Byte.TYPE, 2);
        _typeMap.put(Short.TYPE, 3);
        _typeMap.put(Integer.TYPE, 4);
        _typeMap.put(Long.TYPE, 5);
        _typeMap.put(Float.TYPE, 6);
        _typeMap.put(Double.TYPE, 7);
        _typeMap.put(Boolean.class, 8);
        _typeMap.put(Byte.class, 9);
        _typeMap.put(Short.class, 10);
        _typeMap.put(Integer.class, 11);
        _typeMap.put(Long.class, 12);
        _typeMap.put(Float.class, 13);
        _typeMap.put(Double.class, 14);
        _typeMap.put(String.class, 15);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum CoerceType {
        BOOLEAN,
        CHARACTER,
        STRING,
        INTEGER,
        DOUBLE,
        LONG,
        FLOAT,
        SHORT,
        BYTE,
        BIG_INTEGER,
        BIG_DECIMAL,
        CLASS,
        VOID,
        OBJECT;

    }
}

