/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.env.deploy;

import com.caucho.config.ConfigException;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import java.io.IOException;
import java.util.TreeSet;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ExpandArchiveManager {
    private static final L10N L = new L10N(ExpandArchiveManager.class);
    private final String _id;
    private final Path _archiveDirectory;
    private final String _extension;
    private TreeSet<String> _keySet = new TreeSet();
    private long _digest;

    public ExpandArchiveManager(String id, Path archiveDirectory, String extension) {
        this._id = id;
        this._archiveDirectory = archiveDirectory;
        this._extension = extension;
        if (!extension.startsWith(".")) {
            throw new ConfigException(L.l("deployment extension '{0}' must begin with '.'", (Object)extension));
        }
    }

    public Path getArchiveDirectory() {
        return this._archiveDirectory;
    }

    public Path getArchivePath(String name) {
        return this.getArchiveDirectory().lookup(name + this.getExtension());
    }

    public String getExtension() {
        return this._extension;
    }

    TreeSet<String> getDeployedKeys() {
        long oldDigest = this._digest;
        TreeSet<String> oldKeys = this._keySet;
        long newDigest = this.getDigest();
        if (oldDigest == newDigest) {
            return oldKeys;
        }
        try {
            TreeSet<String> newKeys = this.scanKeys();
            this._digest = newDigest;
            this._keySet = newKeys;
            return newKeys;
        }
        catch (Exception e) {
            throw ConfigException.create(e);
        }
    }

    boolean isModified() {
        return this._digest != this.getDigest();
    }

    boolean logModified(Logger log) {
        long digest = this.getDigest();
        if (this._digest != digest) {
            String reason = "";
            reason = this + " is modified";
            log.info(reason);
            return true;
        }
        return false;
    }

    private long getDigest() {
        return this.getArchiveDirectory().getCrc64();
    }

    private TreeSet<String> scanKeys() throws IOException {
        TreeSet<String> keys = new TreeSet<String>();
        for (String fileName : this.getArchiveDirectory().list()) {
            Path archivePath;
            if (!fileName.endsWith(this.getExtension()) || !(archivePath = this.getArchiveDirectory().lookup(fileName)).canRead() || archivePath.isDirectory()) continue;
            int end = fileName.length() - this._extension.length();
            String key = fileName.substring(0, end);
            keys.add(key);
        }
        return keys;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._id + "," + this.getArchiveDirectory() + "]";
    }
}

