/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.env.deploy;

import com.caucho.env.deploy.AbstractDeployControllerStrategy;
import com.caucho.env.deploy.DeployController;
import com.caucho.env.deploy.DeployControllerStrategy;
import com.caucho.env.deploy.DeployInstance;
import com.caucho.inject.Module;
import com.caucho.lifecycle.LifecycleState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Module
public class StartLazyRedeployAutomaticStrategy
extends AbstractDeployControllerStrategy {
    public static final StartLazyRedeployAutomaticStrategy STRATEGY = new StartLazyRedeployAutomaticStrategy();

    private StartLazyRedeployAutomaticStrategy() {
    }

    public static DeployControllerStrategy create() {
        return STRATEGY;
    }

    @Override
    public <I extends DeployInstance> void startOnInit(DeployController<I> controller) {
        controller.stopLazyImpl();
    }

    @Override
    public <I extends DeployInstance> void update(DeployController<I> controller) {
        LifecycleState state = controller.getState();
        if (!state.isIdle()) {
            if (state.isStopped()) {
                controller.stopLazyImpl();
            } else if (state.isError()) {
                controller.stopLazyImpl();
            } else if (controller.isModifiedNow()) {
                controller.stopLazyImpl();
            } else if (controller.isIdleTimeout()) {
                controller.stopLazyImpl();
            }
        }
    }

    @Override
    public <I extends DeployInstance> I request(DeployController<I> controller) {
        LifecycleState state = controller.getState();
        if (state.isIdle()) {
            return controller.startImpl();
        }
        if (state.isStopped()) {
            return controller.getDeployInstance();
        }
        if (state.isError()) {
            return controller.restartImpl();
        }
        if (controller.isModified()) {
            return controller.restartImpl();
        }
        return controller.getDeployInstance();
    }

    @Override
    public <I extends DeployInstance> I subrequest(DeployController<I> controller) {
        LifecycleState state = controller.getState();
        if (state.isIdle()) {
            return controller.startImpl();
        }
        if (state.isStopped()) {
            return controller.getDeployInstance();
        }
        if (state.isError() && controller.isModified()) {
            return controller.restartImpl();
        }
        if (controller.isModified()) {
            return controller.getDeployInstance();
        }
        return controller.getDeployInstance();
    }

    @Override
    public <I extends DeployInstance> void alarm(DeployController<I> controller) {
        LifecycleState state = controller.getState();
        if (!(state.isIdle() || state.isStopped() || state.isError())) {
            if (controller.isModified()) {
                controller.stopLazyImpl();
            } else if (controller.isIdleTimeout()) {
                controller.stopLazyImpl();
            }
        }
    }
}

