/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.env.jdbc;

import com.caucho.config.ConfigException;
import com.caucho.config.type.ConfigType;
import com.caucho.config.type.TypeFactory;
import com.caucho.env.jdbc.DatabaseFactory;
import com.caucho.sql.DBPool;
import com.caucho.sql.DriverConfig;
import com.caucho.xml.QName;
import java.sql.Driver;
import javax.sql.DataSource;

public class DatabaseFactoryImpl
extends DatabaseFactory {
    private static final QName URL = new QName("url");

    public DataSource create() {
        Class<?> driverClass = this.getDriverClass();
        DBPool pool = new DBPool();
        pool.setName(this.getName());
        DriverConfig driver = pool.createDriver();
        driver.setType(driverClass);
        ConfigType<?> configType = TypeFactory.getType(driverClass);
        if (this.getUrl() != null && (configType.getAttribute(URL) != null || Driver.class.isAssignableFrom(driverClass))) {
            driver.setURL(this.getUrl());
        }
        if (this.getDatabaseName() != null) {
            driver.setProperty("database-name", this.getDatabaseName());
        }
        if (this.getUser() != null) {
            driver.setUser(this.getUser());
        }
        if (this.getPassword() != null) {
            driver.setPassword(this.getPassword());
        }
        try {
            driver.init();
            pool.init();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw ConfigException.create(e);
        }
        return pool;
    }
}

