/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.env.repository;

import com.caucho.env.repository.AbstractRepository;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.TempStream;
import com.caucho.vfs.Vfs;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryTagEntry {
    private final String _tagName;
    private final String _treeHash;
    private final String _tagEntryHash;
    private final String _parent;
    private final Map<String, String> _attributeMap;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RepositoryTagEntry(AbstractRepository repository, String tagName, String treeHash, String parent, Map<String, String> attributeMap) throws IOException {
        if (tagName == null) {
            throw new NullPointerException();
        }
        if (treeHash == null) {
            throw new NullPointerException();
        }
        this._tagName = tagName;
        this._treeHash = treeHash;
        this._parent = parent;
        HashMap<Object, Object> map = attributeMap != null ? new HashMap<String, String>(attributeMap) : new HashMap();
        map.put("tag", tagName);
        map.put("root", treeHash);
        if (parent != null) {
            map.put("parent", parent);
        }
        this._attributeMap = map;
        TempStream os = new TempStream();
        WriteStream out = new WriteStream(os);
        this.writeEntry(out);
        out.close();
        InputStream is = os.getInputStream();
        try {
            this._tagEntryHash = repository.addBlob(is);
        }
        finally {
            is.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RepositoryTagEntry(AbstractRepository repository, String sha1) throws IOException {
        this._tagEntryHash = sha1;
        InputStream is = repository.openBlob(sha1);
        try {
            ReadStream in = Vfs.openRead(is);
            this._attributeMap = this.readMap(in);
            in.close();
            this._tagName = this._attributeMap.get("tag");
            this._treeHash = this._attributeMap.get("root");
            this._parent = this._attributeMap.get("parent");
        }
        finally {
            is.close();
        }
    }

    public String getName() {
        return this._tagName;
    }

    public String getRoot() {
        return this._treeHash;
    }

    public String getTagEntryHash() {
        return this._tagEntryHash;
    }

    public Map<String, String> getAttributeMap() {
        return this._attributeMap;
    }

    private Map<String, String> readMap(ReadStream is) throws IOException {
        String line;
        HashMap<String, String> map = new HashMap<String, String>();
        while ((line = is.readLine()) != null) {
            int p = line.indexOf(": ");
            String key = line.substring(0, p);
            String value = line.substring(p + 2);
            while (value.endsWith("\\")) {
                value = value.substring(0, value.length() - 1);
                line = is.readLine();
                if (line == null) continue;
                value = value + line;
            }
            map.put(key, value);
        }
        return map;
    }

    private void writeEntry(WriteStream out) throws IOException {
        for (Map.Entry<String, String> entry : this._attributeMap.entrySet()) {
            this.writePair(out, entry.getKey(), entry.getValue());
        }
    }

    private void writePair(WriteStream out, String key, String value) throws IOException {
        if (value == null) {
            return;
        }
        while (value.endsWith("\\") || value.endsWith("\n")) {
            value = value.substring(0, value.length() - 1);
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < value.length(); ++i) {
            char ch = value.charAt(i);
            if (ch != '\n') {
                sb.append(ch);
                continue;
            }
            sb.append("\\\n");
        }
        value = sb.toString();
        out.print(key);
        out.print(": ");
        out.println(value);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._tagName + ",root=" + this._treeHash + "]";
    }
}

