/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.filters;

import com.caucho.config.types.Period;
import com.caucho.loader.EnvironmentLocal;
import com.caucho.util.IntMap;
import com.caucho.util.L10N;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;

public class ThrottleFilter
implements Filter {
    private static final L10N L = new L10N(ThrottleFilter.class);
    private static final Logger log = Logger.getLogger(ThrottleFilter.class.getName());
    private static final EnvironmentLocal<ThrottleFilter> _localRef = new EnvironmentLocal();
    private IntMap _throttleCache = new IntMap();
    private ConcurrentHashMap<String, String> _poisonedIpMap = new ConcurrentHashMap();
    private boolean _isPoisonedIp;
    private int _maxConcurrentRequests = 2;
    private int _maxTotalRequests = -1;
    private long _timeout = 120000L;
    private long _requestDelay = 0L;
    private Semaphore _requestSemaphore;

    public ThrottleFilter() {
        _localRef.set(this);
    }

    public static ThrottleFilter getCurrent() {
        return _localRef.get();
    }

    public void setMaxConcurrentRequests(int max) {
        this._maxConcurrentRequests = max;
    }

    public void setMaxTotalRequests(int max) {
        this._maxTotalRequests = max;
    }

    public void setTimeout(Period period) {
        this._timeout = period.getPeriod();
    }

    public void setDelay(Period period) {
        this._requestDelay = period.getPeriod();
    }

    public void addPoisonedIp(String address) {
        this._isPoisonedIp = true;
        this._poisonedIpMap.put(address, address);
    }

    public void init(FilterConfig config) throws ServletException {
        if (this._maxTotalRequests > 0) {
            this._requestSemaphore = new Semaphore(this._maxTotalRequests);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain nextFilter) throws ServletException, IOException {
        boolean isOverflow;
        String ip = request.getRemoteAddr();
        if (this._isPoisonedIp && this._poisonedIpMap.get(ip) != null) {
            log.info(L.l("'{0}' is a poisoned address -- throttling.", (Object)ip));
            if (!(response instanceof HttpServletResponse)) return;
            ((HttpServletResponse)response).sendError(503);
            return;
        }
        ThrottleFilter throttleFilter = this;
        // MONITORENTER : throttleFilter
        int count = this._throttleCache.get(ip);
        if (count <= 0) {
            count = 0;
        }
        if (count < this._maxConcurrentRequests) {
            isOverflow = false;
            this._throttleCache.put(ip, count + 1);
        } else {
            isOverflow = true;
        }
        // MONITOREXIT : throttleFilter
        if (isOverflow) {
            log.info(L.l("'{0}' has too many concurrent requests -- throttling.", (Object)ip));
            if (!(response instanceof HttpServletResponse)) return;
            ((HttpServletResponse)response).sendError(503);
            return;
        }
        try {
            if (this._requestSemaphore != null) {
                boolean isAcquire = false;
                try {
                    if (this._requestSemaphore.tryAcquire(this._timeout, TimeUnit.MILLISECONDS)) {
                        isAcquire = true;
                    }
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if (!isAcquire) {
                    if (response instanceof HttpServletResponse) {
                        ((HttpServletResponse)response).sendError(503);
                    }
                    Object var10_11 = null;
                    ThrottleFilter throttleFilter2 = this;
                    // MONITORENTER : throttleFilter2
                    int count2 = this._throttleCache.get(ip);
                    if (count2 <= 1) {
                        this._throttleCache.remove(ip);
                    } else {
                        this._throttleCache.put(ip, count2 - 1);
                    }
                    // MONITOREXIT : throttleFilter2
                    if (this._requestSemaphore == null) return;
                    this._requestSemaphore.release();
                    return;
                }
            }
            nextFilter.doFilter(request, response);
            if (this._requestDelay > 0L) {
                try {
                    Thread.sleep(this._requestDelay);
                }
                catch (Exception e) {
                }
            }
            Object var10_12 = null;
            ThrottleFilter throttleFilter3 = this;
            // MONITORENTER : throttleFilter3
            int count2 = this._throttleCache.get(ip);
            if (count2 <= 1) {
                this._throttleCache.remove(ip);
            } else {
                this._throttleCache.put(ip, count2 - 1);
            }
            // MONITOREXIT : throttleFilter3
            if (this._requestSemaphore == null) return;
            this._requestSemaphore.release();
            return;
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            ThrottleFilter throttleFilter4 = this;
            // MONITORENTER : throttleFilter4
            int count2 = this._throttleCache.get(ip);
            if (count2 <= 1) {
                this._throttleCache.remove(ip);
            } else {
                this._throttleCache.put(ip, count2 - 1);
            }
            // MONITOREXIT : throttleFilter4
            if (this._requestSemaphore == null) throw throwable;
            this._requestSemaphore.release();
            throw throwable;
        }
    }

    public void destroy() {
    }
}

