/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.hmtp;

import com.caucho.bam.BamException;
import com.caucho.bam.NotAuthorizedException;
import com.caucho.bam.actor.ActorHolder;
import com.caucho.bam.actor.BamActorRef;
import com.caucho.bam.actor.RemoteActorSender;
import com.caucho.bam.broker.Broker;
import com.caucho.bam.client.LinkClient;
import com.caucho.bam.manager.BamManager;
import com.caucho.bam.manager.SimpleBamManager;
import com.caucho.bam.query.QueryCallback;
import com.caucho.bam.query.QueryManager;
import com.caucho.bam.stream.NullActor;
import com.caucho.cloud.security.SecurityService;
import com.caucho.hmtp.AuthQuery;
import com.caucho.hmtp.AuthResult;
import com.caucho.hmtp.ClientAuthManager;
import com.caucho.hmtp.HmtpLinkFactory;
import com.caucho.hmtp.NonceQuery;
import com.caucho.hmtp.SignedCredentials;
import com.caucho.remote.websocket.WebSocketClient;
import com.caucho.security.DigestCredentials;
import com.caucho.util.CurrentTime;
import com.caucho.util.L10N;
import com.caucho.websocket.WebSocketListener;
import java.io.IOException;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HmtpClient
implements RemoteActorSender {
    private static final L10N L = new L10N(HmtpClient.class);
    private static final Logger log = Logger.getLogger(HmtpClient.class.getName());
    private String _url;
    private String _address;
    private String _virtualHost;
    private ActorHolder _actor;
    private BamManager _bamManager;
    private HmtpLinkFactory _linkFactory;
    private LinkClient _linkClient;
    private WebSocketClient _webSocketClient;
    private WebSocketListener _webSocketHandler;
    private BamException _connException;
    private boolean _isMasked;
    private ClientAuthManager _authManager = new ClientAuthManager();

    public HmtpClient(String url, ActorHolder actor) {
        this._actor = actor;
        this._url = url;
        this.init();
    }

    public HmtpClient(String url) {
        this(url, new NullActor("HmtpClient@" + url));
    }

    public void setVirtualHost(String host) {
        this._linkFactory.setVirtualHost(host);
    }

    public void setEncryptPassword(boolean isEncrypt) {
    }

    @Override
    public Broker getBroker() {
        return this._linkClient.getBroker();
    }

    public void connect() {
        this._linkFactory.connect();
    }

    public void connect(String user, String password) {
        this._linkFactory.connect();
        this.loginImpl(user, (Serializable)((Object)password));
    }

    public void connect(String user, Serializable credentials) {
        this._linkFactory.connect();
        this.loginImpl(user, credentials);
    }

    @Override
    public String getUrl() {
        return this._url;
    }

    private void init() {
        this._linkFactory = new HmtpLinkFactory();
        this._linkFactory.setUrl(this._url);
        this._linkFactory.setMasked(this._isMasked);
        this._linkClient = new LinkClient(this._linkFactory, this._actor);
        this._actor.setBroker(this._linkClient.getBroker());
        this._bamManager = new SimpleBamManager(this._linkClient.getBroker());
    }

    protected void connectImpl() {
        try {
            this._linkClient.start();
        }
        catch (BamException e) {
            this._connException = e;
            throw this._connException;
        }
    }

    protected void loginImpl(String uid, Serializable credentials) {
        try {
            if (uid == null) {
                uid = "";
            }
            if (credentials == null) {
                credentials = "";
            }
            if (!(credentials instanceof SignedCredentials) && credentials instanceof String) {
                String password = (String)credentials;
                String clientNonce = String.valueOf(CurrentTime.getCurrentTime());
                NonceQuery nonceQuery = new NonceQuery("", uid, clientNonce);
                NonceQuery nonceResult = (NonceQuery)this.query(null, nonceQuery);
                String serverAlgorithm = nonceResult.getAlgorithm();
                String serverNonce = nonceResult.getNonce();
                String serverSignature = nonceResult.getSignature();
                String testSignature = this._authManager.sign(serverAlgorithm, uid, clientNonce, password);
                if (!testSignature.equals(serverSignature) && "".equals(uid) && !"".equals(password)) {
                    throw new NotAuthorizedException(L.l("{0} cluster-system-key does not match the server's value", (Object)this));
                }
                String signature = this._authManager.sign(serverAlgorithm, uid, serverNonce, password);
                SecurityService security = SecurityService.getCurrent();
                credentials = "".equals(uid) ? new SignedCredentials(uid, serverNonce, signature) : new DigestCredentials(uid, serverNonce, signature);
            }
            AuthResult result = (AuthResult)this.query(null, new AuthQuery(uid, (Serializable)credentials));
            this._address = result.getAddress();
            if (log.isLoggable(Level.FINE)) {
                log.fine(this + " login");
            }
        }
        catch (NotAuthorizedException e) {
            if (uid == null || "".equals(uid)) {
                throw new NotAuthorizedException(L.l("Authentication is required to access the remote service.\n  Include --user and --password parameters to connect, or enable 'cluster_system_key' in resin.properties.\n  {0}", (Object)e.getMessage()), (Throwable)e);
            }
            throw new NotAuthorizedException(L.l("The user '{0}' was not authenticated to access the remote service.\n  The username or password is incorrect.\n  {1}", (Object)uid, (Object)e.getMessage()), (Throwable)e);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getAddress() {
        return this._address;
    }

    public String getBrokerAddress() {
        String address = this.getAddress();
        if (address == null) {
            return null;
        }
        int p = address.indexOf(64);
        int q = address.indexOf(47);
        if (p >= 0 && q >= 0) {
            return address.substring(p + 1, q);
        }
        if (p >= 0) {
            return address.substring(p + 1);
        }
        if (q >= 0) {
            return address.substring(0, q);
        }
        return address;
    }

    public void flush() throws IOException {
    }

    @Override
    public void close() {
        if (log.isLoggable(Level.FINE)) {
            log.fine(this + " close");
        }
        HmtpLinkFactory linkFactory = this._linkFactory;
        this._linkFactory = null;
        if (linkFactory != null) {
            linkFactory.close();
        }
        LinkClient linkClient = this._linkClient;
        this._linkClient = null;
        if (linkClient != null) {
            linkClient.close();
        }
        if (this._webSocketClient != null) {
            this._webSocketClient.close(1000, "ok");
        }
    }

    @Override
    public boolean isClosed() {
        return false;
    }

    @Override
    public long nextQueryId() {
        return this._linkClient.getSender().nextQueryId();
    }

    @Override
    public void message(String to, Serializable payload) {
        this._linkClient.getSender().message(to, payload);
    }

    @Override
    public void message(BamActorRef to, Serializable payload) {
        this._linkClient.getSender().message(to, payload);
    }

    @Override
    public Serializable query(String to, Serializable payload) {
        return this._linkClient.getSender().query(to, payload);
    }

    @Override
    public Serializable query(String to, Serializable payload, long timeout) {
        return this._linkClient.getSender().query(to, payload, timeout);
    }

    @Override
    public void query(String to, Serializable payload, QueryCallback callback) {
        this._linkClient.getSender().query(to, payload, callback);
    }

    @Override
    public void query(String to, Serializable payload, QueryCallback callback, long timeout) {
        this._linkClient.getSender().query(to, payload, callback, timeout);
    }

    @Override
    public void query(BamActorRef to, Serializable payload, QueryCallback callback) {
        this._linkClient.getSender().query(to, payload, callback);
    }

    @Override
    public void query(BamActorRef to, Serializable payload, QueryCallback callback, long timeout) {
        this._linkClient.getSender().query(to, payload, callback, timeout);
    }

    @Override
    public QueryManager getQueryManager() {
        return this._linkClient.getSender().getQueryManager();
    }

    public <T> T createProxy(Class<T> api, String to) {
        BamActorRef toRef = this._bamManager.createActorRef(to);
        return this._bamManager.createProxy(api, toRef, this._linkClient.getSender());
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._url + "," + this._actor + "]";
    }

    protected void finalize() {
        this.close();
    }
}

