/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jca.ra;

import com.caucho.jca.ra.ResourceDeploy;
import com.caucho.management.server.AbstractManagedObject;
import com.caucho.management.server.ResourceDeployMXBean;
import com.caucho.vfs.Path;

public class ResourceDeployAdmin
extends AbstractManagedObject
implements ResourceDeployMXBean {
    private final ResourceDeploy _resourceDeploy;

    public ResourceDeployAdmin(ResourceDeploy resourceDeploy) {
        this._resourceDeploy = resourceDeploy;
    }

    protected ResourceDeploy getResourceDeploy() {
        return this._resourceDeploy;
    }

    void register() {
        this.registerSelf();
    }

    void unregister() {
        this.registerSelf();
    }

    public String getName() {
        Path containerRootDirectory = this.getResourceDeploy().getContainerRootDirectory();
        Path archiveDirectory = this.getResourceDeploy().getArchiveDirectory();
        if (containerRootDirectory == null) {
            return archiveDirectory.getNativePath();
        }
        return containerRootDirectory.lookupRelativeNativePath(archiveDirectory);
    }

    public long getDependencyCheckInterval() {
        return this.getResourceDeploy().getDependencyCheckInterval();
    }

    public String getArchiveDirectory() {
        return this.getResourceDeploy().getArchiveDirectory().getNativePath();
    }

    public String getArchivePath(String name) {
        return this.getResourceDeploy().getArchivePath(name).getNativePath();
    }

    public String getExtension() {
        return this.getResourceDeploy().getExtension();
    }

    public String getExpandDirectory() {
        return this.getResourceDeploy().getExpandDirectory().getNativePath();
    }

    public String getExpandPrefix() {
        return this.getResourceDeploy().getExpandPrefix();
    }

    public String getExpandSuffix() {
        return this.getResourceDeploy().getExpandSuffix();
    }

    public String getExpandPath(String name) {
        Path path = this.getResourceDeploy().getExpandPath(name);
        return path == null ? null : path.getNativePath();
    }

    public String getRedeployMode() {
        return this.getResourceDeploy().getRedeployMode().toString();
    }

    public String getStartupMode() {
        return this.getResourceDeploy().getStartupMode().toString();
    }

    public boolean isModified() {
        return this.getResourceDeploy().isModified();
    }

    public String getState() {
        return this.getResourceDeploy().getState();
    }

    public void start() {
        this.getResourceDeploy().start();
    }

    public Throwable getConfigException() {
        return this.getResourceDeploy().getConfigException();
    }

    public void stop() {
        this.getResourceDeploy().stop();
    }

    public void update() {
        this.getResourceDeploy().update();
    }

    public String[] getNames() {
        return this.getResourceDeploy().getNames();
    }

    public void deploy(String name) {
        this.getResourceDeploy().start(name);
    }

    public void start(String name) {
        this.getResourceDeploy().start(name);
    }

    public Throwable getConfigException(String moduleID) {
        return this.getResourceDeploy().getConfigException(moduleID);
    }

    public void stop(String name) {
        this.getResourceDeploy().stop(name);
    }

    public void undeploy(String name) {
        this.getResourceDeploy().undeploy(name);
    }
}

