/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jms.connection;

import com.caucho.env.thread.ThreadPool;
import com.caucho.jms.connection.ConnectionImpl;
import com.caucho.jms.connection.MessageBrowserImpl;
import com.caucho.jms.connection.MessageConsumerImpl;
import com.caucho.jms.connection.MessageProducerImpl;
import com.caucho.jms.connection.QueueReceiverImpl;
import com.caucho.jms.connection.TemporaryQueueImpl;
import com.caucho.jms.connection.TemporaryTopicImpl;
import com.caucho.jms.connection.TopicSubscriberImpl;
import com.caucho.jms.message.BytesMessageImpl;
import com.caucho.jms.message.MapMessageImpl;
import com.caucho.jms.message.MessageFactory;
import com.caucho.jms.message.MessageImpl;
import com.caucho.jms.message.ObjectMessageImpl;
import com.caucho.jms.message.StreamMessageImpl;
import com.caucho.jms.message.TextMessageImpl;
import com.caucho.jms.queue.AbstractDestination;
import com.caucho.jms.queue.AbstractQueue;
import com.caucho.jms.queue.AbstractTopic;
import com.caucho.util.Base64;
import com.caucho.util.CurrentTime;
import com.caucho.util.L10N;
import com.caucho.util.RandomUtil;
import com.caucho.util.ThreadTask;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.concurrent.Semaphore;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;
import javax.jms.XASession;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class JmsSession
implements XASession,
ThreadTask,
XAResource {
    protected static final Logger log = Logger.getLogger(JmsSession.class.getName());
    protected static final L10N L = new L10N(JmsSession.class);
    private static final long SHUTDOWN_WAIT_TIME = 10000L;
    private boolean _isXA;
    private Xid _xid;
    private TransactionManager _tm;
    private boolean _isTransacted;
    private int _acknowledgeMode;
    private ClassLoader _classLoader;
    private ConnectionImpl _connection;
    private final ArrayList<MessageConsumerImpl<Message>> _consumers = new ArrayList();
    private MessageFactory _messageFactory = new MessageFactory();
    private MessageListener _messageListener;
    private boolean _isAsynchronous;
    private Thread _thread;
    private ArrayList<TransactedMessage> _transactedMessages;
    private volatile boolean _isRunning;
    private volatile boolean _isClosed;
    private volatile boolean _hasMessage;
    private String _publisherId;
    private Semaphore _listenSemaphore = new Semaphore(1);

    public JmsSession(ConnectionImpl connection, boolean isTransacted, int ackMode, boolean isXA) throws JMSException {
        this._classLoader = Thread.currentThread().getContextClassLoader();
        this._connection = connection;
        this._isXA = isXA;
        this._isTransacted = isTransacted;
        this._acknowledgeMode = ackMode;
        StringBuilder sb = new StringBuilder();
        sb.append("jms:");
        Base64.encode(sb, RandomUtil.getRandomLong());
        this._publisherId = sb.toString();
        if (isTransacted) {
            this._acknowledgeMode = 0;
        } else {
            switch (ackMode) {
                case 1: 
                case 2: 
                case 3: {
                    this._acknowledgeMode = ackMode;
                    break;
                }
                default: {
                    try {
                        log.warning(L.l("JmsSession {0} is an illegal acknowledge mode", ackMode));
                        log.warning(L.l("JmsSession {0} is an illegal acknowledge mode", ackMode));
                        this._acknowledgeMode = 1;
                        break;
                    }
                    catch (Exception e) {
                        log.log(Level.FINE, e.toString(), e);
                    }
                }
            }
        }
        this._connection.addSession(this);
    }

    ConnectionImpl getConnection() {
        return this._connection;
    }

    ClassLoader getClassLoader() {
        return this._classLoader;
    }

    public String getClientID() throws JMSException {
        return this._connection.getClientID();
    }

    public String getPublisherId() {
        return this._publisherId;
    }

    public boolean isActive() {
        return !this._isClosed && this._connection.isActive();
    }

    boolean isStopping() {
        return this._connection.isStopping();
    }

    public boolean getTransacted() throws JMSException {
        this.checkOpen();
        return this._isTransacted;
    }

    public int getAcknowledgeMode() throws JMSException {
        this.checkOpen();
        return this._acknowledgeMode;
    }

    public MessageListener getMessageListener() throws JMSException {
        this.checkOpen();
        return this._messageListener;
    }

    public void setMessageListener(MessageListener listener) throws JMSException {
        this.checkOpen();
        this._messageListener = listener;
        this.setAsynchronous();
    }

    void setAsynchronous() {
        this._isAsynchronous = true;
        this.notifyMessageAvailable();
    }

    boolean isAsynchronous() {
        return this._isAsynchronous;
    }

    public BytesMessage createBytesMessage() throws JMSException {
        this.checkOpen();
        return new BytesMessageImpl();
    }

    public MapMessage createMapMessage() throws JMSException {
        this.checkOpen();
        return new MapMessageImpl();
    }

    public Message createMessage() throws JMSException {
        this.checkOpen();
        return new MessageImpl();
    }

    public ObjectMessage createObjectMessage() throws JMSException {
        this.checkOpen();
        return new ObjectMessageImpl();
    }

    public ObjectMessage createObjectMessage(Serializable obj) throws JMSException {
        this.checkOpen();
        ObjectMessage msg = this.createObjectMessage();
        msg.setObject(obj);
        return msg;
    }

    public StreamMessage createStreamMessage() throws JMSException {
        this.checkOpen();
        return new StreamMessageImpl();
    }

    public TextMessage createTextMessage() throws JMSException {
        this.checkOpen();
        return new TextMessageImpl();
    }

    public TextMessage createTextMessage(String message) throws JMSException {
        this.checkOpen();
        TextMessage msg = this.createTextMessage();
        msg.setText(message);
        return msg;
    }

    public MessageConsumer createConsumer(Destination destination) throws JMSException {
        this.checkOpen();
        return this.createConsumer(destination, null, false);
    }

    public MessageConsumer createConsumer(Destination destination, String messageSelector) throws JMSException {
        this.checkOpen();
        return this.createConsumer(destination, messageSelector, false);
    }

    public MessageConsumer createConsumer(Destination destination, String messageSelector, boolean noLocal) throws JMSException {
        MessageConsumerImpl consumer;
        this.checkOpen();
        if (destination == null) {
            throw new InvalidDestinationException(L.l("destination is null.  Destination may not be null for Session.createConsumer"));
        }
        if (destination instanceof TemporaryQueueImpl) {
            if (!((TemporaryQueueImpl)destination).getSession().getConnection().equals(this._connection)) {
                throw new IllegalStateException(L.l("temporary queue '{0}' does not belong to this session '{1}'", (Object)destination, (Object)this));
            }
            ((TemporaryQueueImpl)destination).addMessageConsumer();
        }
        if (destination instanceof TemporaryTopicImpl) {
            if (!((TemporaryTopicImpl)destination).getSession().getConnection().equals(this._connection)) {
                throw new IllegalStateException(L.l("temporary queue '{0}' does not belong to this session '{1}'", (Object)destination, (Object)this));
            }
            ((TemporaryTopicImpl)destination).addMessageConsumer();
        }
        if (destination instanceof AbstractQueue) {
            AbstractQueue dest = (AbstractQueue)destination;
            consumer = new QueueReceiverImpl(this, dest, messageSelector, noLocal);
        } else if (destination instanceof AbstractTopic) {
            AbstractTopic dest = (AbstractTopic)destination;
            consumer = new TopicSubscriberImpl(this, dest, messageSelector, noLocal);
        } else {
            throw new InvalidDestinationException(L.l("'{0}' is an unknown destination.  The destination must be a Resin JMS Destination.", (Object)destination));
        }
        this.addConsumer(consumer);
        if (this.isActive()) {
            consumer.start();
        }
        return consumer;
    }

    public MessageProducer createProducer(Destination destination) throws JMSException {
        this.checkOpen();
        if (destination == null) {
            return new MessageProducerImpl(this, null);
        }
        if (!(destination instanceof AbstractDestination)) {
            throw new InvalidDestinationException(L.l("'{0}' is an unknown destination.  The destination must be a Resin JMS destination for Session.createProducer.", (Object)destination));
        }
        AbstractDestination dest = (AbstractDestination)destination;
        return new MessageProducerImpl(this, dest);
    }

    public QueueBrowser createBrowser(Queue queue) throws JMSException {
        this.checkOpen();
        return this.createBrowser(queue, null);
    }

    public QueueBrowser createBrowser(Queue queue, String messageSelector) throws JMSException {
        this.checkOpen();
        if (queue == null) {
            throw new InvalidDestinationException(L.l("queue is null.  Queue may not be null for Session.createBrowser"));
        }
        if (!(queue instanceof AbstractQueue)) {
            throw new InvalidDestinationException(L.l("'{0}' is an unknown queue.  The queue must be a Resin JMS Queue for Session.createBrowser.", (Object)queue));
        }
        return new MessageBrowserImpl(this, (AbstractQueue)queue, messageSelector);
    }

    public Queue createQueue(String queueName) throws JMSException {
        this.checkOpen();
        return this._connection.createQueue(queueName);
    }

    public TemporaryQueue createTemporaryQueue() throws JMSException {
        this.checkOpen();
        return new TemporaryQueueImpl(this);
    }

    public Topic createTopic(String topicName) throws JMSException {
        this.checkOpen();
        return this._connection.createTopic(topicName);
    }

    public TemporaryTopic createTemporaryTopic() throws JMSException {
        this.checkOpen();
        return new TemporaryTopicImpl(this);
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name) throws JMSException {
        this.checkOpen();
        if (this.getClientID() == null) {
            throw new JMSException(L.l("connection may not create a durable subscriber because it does not have an assigned ClientID."));
        }
        return this.createDurableSubscriber(topic, name, null, false);
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name, String messageSelector, boolean noLocal) throws JMSException {
        this.checkOpen();
        if (topic == null) {
            throw new InvalidDestinationException(L.l("destination is null.  Destination may not be null for Session.createDurableSubscriber"));
        }
        if (!(topic instanceof AbstractTopic)) {
            throw new InvalidDestinationException(L.l("'{0}' is an unknown destination.  The destination must be a Resin JMS Destination.", (Object)topic));
        }
        AbstractTopic topicImpl = (AbstractTopic)topic;
        if (this._connection.getDurableSubscriber(name) != null) {
            // empty if block
        }
        AbstractQueue queue = topicImpl.createSubscriber(this.getPublisherId(), name, noLocal);
        TopicSubscriberImpl consumer = new TopicSubscriberImpl(this, topicImpl, queue, messageSelector, noLocal);
        this._connection.putDurableSubscriber(name, consumer);
        this.addConsumer(consumer);
        return consumer;
    }

    public void unsubscribe(String name) throws JMSException {
        this.checkOpen();
        if (name == null) {
            throw new InvalidDestinationException(L.l("destination is null.  Destination may not be null for Session.unsubscribe"));
        }
        TopicSubscriber subscriber = this._connection.removeDurableSubscriber(name);
        if (subscriber == null) {
            throw new InvalidDestinationException(L.l("'{0}' is an unknown subscriber for Session.unsubscribe", (Object)name));
        }
        subscriber.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void start() {
        if (log.isLoggable(Level.FINE)) {
            log.fine(this.toString() + " active");
        }
        ArrayList<MessageConsumerImpl<Message>> arrayList = this._consumers;
        synchronized (arrayList) {
            for (MessageConsumerImpl<Message> consumer : this._consumers) {
                consumer.start();
            }
        }
        this.notifyMessageAvailable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stop() {
        if (log.isLoggable(Level.FINE)) {
            log.fine(this.toString() + " stopping");
        }
        ArrayList<MessageConsumerImpl<Message>> arrayList = this._consumers;
        synchronized (arrayList) {
            long timeout = CurrentTime.getCurrentTime() + 10000L;
            while (this._isRunning && CurrentTime.getCurrentTime() < timeout) {
                try {
                    this._consumers.wait(10000L);
                    if (!CurrentTime.isTest()) continue;
                    return;
                }
                catch (Throwable e) {
                    log.log(Level.FINER, e.toString(), e);
                }
            }
            ArrayList<MessageConsumerImpl<Message>> consumers = new ArrayList<MessageConsumerImpl<Message>>(this._consumers);
            for (MessageConsumerImpl<Message> consumer : consumers) {
                try {
                    consumer.stop();
                }
                catch (Throwable e) {
                    log.log(Level.FINE, e.toString(), e);
                }
            }
        }
    }

    public void commit() throws JMSException {
        this.checkOpen();
        this.commit(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commit(boolean isXA) throws JMSException {
        this._xid = null;
        if (!this._isTransacted && !isXA) {
            throw new IllegalStateException(L.l("commit() can only be called on a transacted session."));
        }
        this._isXA = false;
        ArrayList<TransactedMessage> messages = this._transactedMessages;
        if (messages == null || messages.size() == 0) {
            return;
        }
        try {
            for (int i = 0; i < messages.size(); ++i) {
                TransactedMessage msg = messages.get(i);
                if (msg == null) continue;
                msg.commit();
            }
            Object var6_5 = null;
            messages.clear();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            messages.clear();
            throw throwable;
        }
        if (!isXA) {
            this.acknowledge();
        }
    }

    public void acknowledge() throws JMSException {
        this.checkOpen();
        if (this._transactedMessages != null) {
            for (int i = this._transactedMessages.size() - 1; i >= 0; --i) {
                TransactedMessage msg = this._transactedMessages.get(i);
                if (!(msg instanceof ReceiveMessage)) continue;
                this._transactedMessages.remove(i);
                msg.commit();
            }
        }
    }

    public void recover() throws JMSException {
        this.checkOpen();
        if (this._isTransacted) {
            throw new IllegalStateException(L.l("recover() may not be called on a transacted session."));
        }
        if (this._transactedMessages != null) {
            for (int i = this._transactedMessages.size() - 1; i >= 0; --i) {
                TransactedMessage msg = this._transactedMessages.get(i);
                if (!(msg instanceof ReceiveMessage)) continue;
                this._transactedMessages.remove(i);
                msg.rollback();
            }
        }
    }

    public void rollback() throws JMSException {
        this.checkOpen();
        this.rollbackImpl();
    }

    public void rollbackImpl() throws JMSException {
        if (!this._isTransacted && !this._isXA) {
            throw new IllegalStateException(L.l("rollback() can only be called on a transacted session."));
        }
        if (this._transactedMessages != null) {
            for (int i = 0; i < this._transactedMessages.size(); ++i) {
                this._transactedMessages.get(i).rollback();
            }
            this._transactedMessages.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws JMSException {
        int i;
        if (this._isClosed) {
            return;
        }
        try {
            this.stop();
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
        }
        ArrayList<TransactedMessage> messages = this._transactedMessages;
        if (messages != null && this._xid == null) {
            this._transactedMessages = null;
            try {
                for (i = 0; i < messages.size(); ++i) {
                    messages.get(i).close();
                }
            }
            catch (Exception e) {
                log.log(Level.WARNING, e.toString(), e);
            }
        }
        for (i = 0; i < this._consumers.size(); ++i) {
            MessageConsumerImpl<Message> consumer = this._consumers.get(i);
            try {
                consumer.close();
                continue;
            }
            catch (Exception e) {
                log.log(Level.WARNING, e.toString(), e);
            }
        }
        try {
            this._connection.removeSession(this);
            Object var6_7 = null;
            this._isClosed = true;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this._isClosed = true;
            throw throwable;
        }
        this._classLoader = null;
    }

    protected void addConsumer(MessageConsumerImpl consumer) {
        this._consumers.add(consumer);
        this.notifyMessageAvailable();
    }

    protected void removeConsumer(MessageConsumerImpl consumer) {
        if (this._consumers != null) {
            this._consumers.remove(consumer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean notifyMessageAvailable() {
        ArrayList<MessageConsumerImpl<Message>> arrayList = this._consumers;
        synchronized (arrayList) {
            this._hasMessage = true;
            if (this._isRunning || !this._isAsynchronous || !this.isActive()) {
                return false;
            }
            this._isRunning = true;
        }
        ThreadPool.getThreadPool().schedule(this);
        if (CurrentTime.isTest()) {
            try {
                Thread.sleep(10L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return true;
    }

    public void send(AbstractDestination queue, Message appMessage, int deliveryMode, int priority, long timeout) throws JMSException {
        this.checkOpen();
        if (queue == null) {
            throw new UnsupportedOperationException(L.l("empty queue is not allowed for this session."));
        }
        if (appMessage.getJMSDestination() == null) {
            appMessage.setJMSDestination(queue);
        }
        long now = CurrentTime.getExactTime();
        long expireTime = 0L;
        if (timeout == 0L) {
            expireTime = now + 2592000000L;
        } else {
            expireTime = now + timeout;
            appMessage.setJMSExpiration(expireTime);
        }
        appMessage.setJMSMessageID(queue.generateMessageID());
        appMessage.setJMSPriority(priority);
        appMessage.setJMSTimestamp(now);
        appMessage.setJMSDeliveryMode(deliveryMode);
        MessageImpl message = this._messageFactory.copy(appMessage);
        boolean isXA = false;
        try {
            if (this._isTransacted && this._tm != null && this._tm.getTransaction() != null) {
                isXA = true;
            }
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
        }
        if (this._isTransacted || isXA) {
            if (this._transactedMessages == null) {
                this._transactedMessages = new ArrayList();
            }
            SendMessage transMsg = new SendMessage(queue, message, expireTime);
            this._transactedMessages.add(transMsg);
            if (this._xid == null) {
                this.enlist();
            }
        } else {
            if (log.isLoggable(Level.FINE)) {
                log.fine(queue + " sending " + message);
            }
            queue.send(message.getJMSMessageID(), message, priority, expireTime, this.getPublisherId());
        }
    }

    private void enlist() {
        if (this._tm != null) {
            try {
                Transaction trans = this._tm.getTransaction();
                if (trans != null) {
                    trans.enlistResource(this);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void delist() {
        if (this._tm != null) {
            try {
                Transaction trans = this._tm.getTransaction();
                if (trans != null) {
                    trans.delistResource(this, 0);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    void addTransactedReceive(AbstractDestination queue, MessageImpl message) {
        message.setSession(this);
        if (this._transactedMessages == null) {
            this._transactedMessages = new ArrayList();
        }
        ReceiveMessage transMsg = new ReceiveMessage(queue, message);
        this._transactedMessages.add(transMsg);
        if (this._tm != null && this._transactedMessages.size() == 1) {
            this.enlist();
        }
    }

    public Session getSession() {
        return this;
    }

    public XAResource getXAResource() {
        return this;
    }

    public boolean isSameRM(XAResource xa) throws XAException {
        return this == xa;
    }

    public boolean setTransactionTimeout(int timeout) throws XAException {
        return true;
    }

    public int getTransactionTimeout() throws XAException {
        return 0;
    }

    public void start(Xid xid, int flags) throws XAException {
        this._xid = xid;
    }

    public void end(Xid xid, int flags) throws XAException {
        this._xid = null;
    }

    public int prepare(Xid xid) throws XAException {
        return 0;
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        try {
            try {
                this.commit(true);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            Object var5_3 = null;
            this.delist();
            this._isXA = false;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            this.delist();
            this._isXA = false;
            throw throwable;
        }
    }

    public void rollback(Xid xid) throws XAException {
        try {
            try {
                this.rollbackImpl();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            Object var4_2 = null;
            this.delist();
            this._isXA = false;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            this.delist();
            this._isXA = false;
            throw throwable;
        }
    }

    public void forget(Xid xid) throws XAException {
    }

    public Xid[] recover(int flag) throws XAException {
        return null;
    }

    public void acquireListenSemaphore() {
        try {
            this._listenSemaphore.acquire();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void releaseListenSemaphore() {
        try {
            this._listenSemaphore.release();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Thread.currentThread().setContextClassLoader(this._classLoader);
        boolean isValid = true;
        while (isValid) {
            ArrayList<MessageConsumerImpl<Message>> arrayList;
            Object var5_4;
            isValid = false;
            this._hasMessage = false;
            try {
                for (int i = 0; i < this._consumers.size(); ++i) {
                    MessageConsumerImpl<Message> consumer = this._consumers.get(i);
                    while (this.isActive() && consumer.handleMessage(this._messageListener)) {
                    }
                }
                isValid = this.isActive();
                var5_4 = null;
                arrayList = this._consumers;
            }
            catch (Throwable throwable) {
                var5_4 = null;
                arrayList = this._consumers;
                synchronized (arrayList) {
                    if (!isValid) {
                        this._isRunning = false;
                    } else if (!this._hasMessage) {
                        this._isRunning = false;
                        isValid = false;
                    }
                    this._consumers.notifyAll();
                }
                throw throwable;
            }
            synchronized (arrayList) {
                if (!isValid) {
                    this._isRunning = false;
                } else if (!this._hasMessage) {
                    this._isRunning = false;
                    isValid = false;
                }
                this._consumers.notifyAll();
            }
        }
    }

    public boolean isClosed() {
        return this._isClosed;
    }

    public void checkOpen() throws IllegalStateException {
        if (this._isClosed) {
            throw new IllegalStateException(L.l("session is closed"));
        }
    }

    void checkThread() throws JMSException {
        Thread thread = this._thread;
        if (thread != Thread.currentThread() && thread != null) {
            IllegalStateException e = new IllegalStateException(L.l("Can't use session from concurrent threads."));
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ReceiveMessage
    extends TransactedMessage {
        private final AbstractDestination<Message> _queue;
        private final MessageImpl _message;

        ReceiveMessage(AbstractDestination<Message> queue, MessageImpl message) {
            this._queue = queue;
            this._message = message;
            if (queue == null) {
                throw new NullPointerException();
            }
            if (this._message == null || message.getJMSMessageID() == null) {
                throw new NullPointerException();
            }
        }

        @Override
        void commit() throws JMSException {
            this._queue.acknowledge(this._message.getJMSMessageID());
        }

        @Override
        void rollback() throws JMSException {
            if (this._message.getJMSRedelivered()) {
                log.warning(this + " removing rollbacked message " + this._message);
                this._queue.acknowledge(this._message.getJMSMessageID());
            } else {
                this._queue.rollback(this._message.getJMSMessageID());
                this._message.setJMSRedelivered(true);
            }
        }

        @Override
        void close() throws JMSException {
            this.rollback();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class SendMessage
    extends TransactedMessage {
        private final AbstractDestination<Message> _queue;
        private final MessageImpl _message;
        private final long _expires;

        SendMessage(AbstractDestination<Message> queue, MessageImpl message, long expires) {
            this._queue = queue;
            this._message = message;
            this._expires = expires;
        }

        @Override
        void commit() throws JMSException {
            this._queue.send(this._message.getJMSMessageID(), this._message, this._message.getJMSPriority(), this._expires, JmsSession.this.getPublisherId());
        }

        @Override
        void rollback() throws JMSException {
        }

        @Override
        void close() throws JMSException {
            this.commit();
        }
    }

    abstract class TransactedMessage {
        TransactedMessage() {
        }

        abstract void commit() throws JMSException;

        abstract void rollback() throws JMSException;

        abstract void close() throws JMSException;
    }
}

