/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jms.file;

import com.caucho.jms.file.FileQueueEntry;
import com.caucho.jms.file.FileQueueStore;
import com.caucho.jms.queue.AbstractMemoryQueue;
import com.caucho.loader.Environment;
import com.caucho.server.cluster.ServletService;
import com.caucho.util.Hex;
import com.caucho.vfs.Path;
import java.io.Serializable;
import java.security.MessageDigest;
import javax.jms.Topic;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileQueueImpl<E extends Serializable>
extends AbstractMemoryQueue<E, FileQueueEntry<E>>
implements Topic {
    private final FileQueueStore _store;
    private byte[] _queueIdHash;

    public FileQueueImpl() {
        this._store = FileQueueStore.create();
    }

    public FileQueueImpl(byte[] queueHash) {
        this();
        this.setName(Hex.toHex(queueHash, 0, 8));
        this._queueIdHash = queueHash;
        this.init();
    }

    public FileQueueImpl(String name) {
        this();
        this.setName(name);
        this.init();
    }

    FileQueueImpl(Path path, String name, String serverId) {
        try {
            path.mkdirs();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (serverId == null) {
            serverId = "anon";
        }
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        this._store = new FileQueueStore(path, serverId, loader);
        this.setName(name);
        this.init();
    }

    @Deprecated
    public void setPath(Path path) {
    }

    public Path getPath() {
        return null;
    }

    @Deprecated
    public void setTablePrefix(String prefix) {
    }

    @Override
    public String getUrl() {
        return "file:name=" + this.getName();
    }

    @Override
    public void init() {
        try {
            if (this._queueIdHash == null) {
                MessageDigest digest = MessageDigest.getInstance("SHA-256");
                String env = Environment.getEnvironmentName();
                digest.update(env.getBytes());
                if (ServletService.getCurrent() != null) {
                    digest.update(ServletService.getCurrent().getServerId().getBytes());
                }
                digest.update(this.getClass().getSimpleName().getBytes());
                digest.update(this.getName().getBytes());
                this._queueIdHash = digest.digest();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this._store.receiveStart(this._queueIdHash, this);
    }

    @Override
    public FileQueueEntry<E> writeEntry(String msgId, E payload, int priority, long expireTime) {
        long id = this._store.send(this._queueIdHash, msgId, (Serializable)payload, priority, expireTime);
        long leaseTimeout = -1L;
        FileQueueEntry<E> entry = new FileQueueEntry<E>(id, msgId, leaseTimeout, priority, expireTime, payload);
        return entry;
    }

    @Override
    protected void readPayload(FileQueueEntry<E> entry) {
        Serializable payload = (Serializable)entry.getPayload();
        if (payload == null) {
            payload = (Serializable)entry.getPayloadRef();
            if (payload == null) {
                payload = this._store.readMessage(entry.getId());
            }
            entry.setPayload(payload);
        }
    }

    @Override
    protected void acknowledge(FileQueueEntry<E> entry) {
        this._store.delete(entry.getId());
    }

    protected void addEntry(long id, String msgId, long leaseTimeout, int priority, long expireTime, E payload) {
        FileQueueEntry<E> entry = new FileQueueEntry<E>(id, msgId, leaseTimeout, priority, expireTime, payload);
        this.addQueueEntry(entry, expireTime);
    }

    public int getFileStoreMessageCount() {
        return this._store.getMessageCount();
    }
}

