/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jms.jca;

import com.caucho.config.ConfigException;
import com.caucho.config.program.ConfigProgram;
import com.caucho.jms.jca.ListenerEndpoint;
import com.caucho.util.L10N;
import java.lang.reflect.Method;
import java.util.logging.Logger;
import javax.resource.spi.UnavailableException;
import javax.resource.spi.endpoint.MessageEndpoint;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.transaction.xa.XAResource;

public class ListenerEndpointFactory
implements MessageEndpointFactory {
    private static final Logger log = Logger.getLogger(ListenerEndpointFactory.class.getName());
    private static final L10N L = new L10N(ListenerEndpointFactory.class);
    private ConfigProgram _program;
    private ListenerEndpoint _initialEndpoint;

    public void setListener(ConfigProgram program) throws Throwable {
        this._program = program;
        this._initialEndpoint = new ListenerEndpoint();
        program.configure(this._initialEndpoint);
    }

    public void init() throws ConfigException {
        if (this._initialEndpoint == null) {
            throw new ConfigException(L.l("ListenerEndpointFactory needs a <listener>"));
        }
    }

    public MessageEndpoint createEndpoint(XAResource xaResource, long timeout) throws UnavailableException {
        return this.createEndpoint(xaResource);
    }

    public MessageEndpoint createEndpoint(XAResource xaResource) throws UnavailableException {
        try {
            ListenerEndpoint listener = this._initialEndpoint;
            this._initialEndpoint = null;
            if (listener == null) {
                listener = new ListenerEndpoint();
                this._program.configure(listener);
            }
            return listener;
        }
        catch (Throwable e) {
            throw new UnavailableException(e);
        }
    }

    public boolean isDeliveryTransacted(Method method) {
        return false;
    }
}

