/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jms.message;

import com.caucho.hessian.io.Hessian2Input;
import com.caucho.hessian.io.Hessian2Output;
import com.caucho.jms.message.MessageImpl;
import com.caucho.jms.message.MessageType;
import com.caucho.jms.message.ObjectConverter;
import com.caucho.vfs.StreamImplOutputStream;
import com.caucho.vfs.TempStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.MessageFormatException;

public class MapMessageImpl
extends MessageImpl
implements MapMessage {
    private HashMap<String, Object> _map = new HashMap();

    public MapMessageImpl() {
    }

    MapMessageImpl(MapMessage map) throws JMSException {
        super(map);
        Enumeration e = map.getMapNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            this._map.put(name, map.getObject(name));
        }
    }

    MapMessageImpl(MapMessageImpl map) {
        super(map);
        this._map.putAll(map._map);
    }

    public MessageType getType() {
        return MessageType.MAP;
    }

    public boolean itemExists(String name) throws JMSException {
        return this._map.containsKey(name);
    }

    public Enumeration getMapNames() throws JMSException {
        return Collections.enumeration(this._map.keySet());
    }

    public boolean getBoolean(String name) throws JMSException {
        return ObjectConverter.toBoolean(this.getObject(name));
    }

    public byte getByte(String name) throws JMSException {
        return ObjectConverter.toByte(this.getObject(name));
    }

    public short getShort(String name) throws JMSException {
        return ObjectConverter.toShort(this.getObject(name));
    }

    public int getInt(String name) throws JMSException {
        return ObjectConverter.toInt(this.getObject(name));
    }

    public long getLong(String name) throws JMSException {
        return ObjectConverter.toLong(this.getObject(name));
    }

    public float getFloat(String name) throws JMSException {
        return ObjectConverter.toFloat(this.getObject(name));
    }

    public double getDouble(String name) throws JMSException {
        return ObjectConverter.toDouble(this.getObject(name));
    }

    public char getChar(String name) throws JMSException {
        return ObjectConverter.toChar(this.getObject(name));
    }

    public String getString(String name) throws JMSException {
        return ObjectConverter.toString(this.getObject(name));
    }

    public byte[] getBytes(String name) throws JMSException {
        return ObjectConverter.toBytes(this.getObject(name));
    }

    public int getBytes(String name, byte[] value) throws JMSException {
        byte[] bytes = ObjectConverter.toBytes(this.getObject(name));
        if (bytes == null) {
            return 0;
        }
        int sublen = bytes.length;
        if (value.length < sublen) {
            sublen = value.length;
        }
        for (int i = 0; i < sublen; ++i) {
            value[i] = bytes[i];
        }
        return sublen;
    }

    public Object getObject(String name) throws JMSException {
        return this._map.get(name);
    }

    public void clearBody() throws JMSException {
        super.clearBody();
        this._map.clear();
    }

    public void setBoolean(String name, boolean b) throws JMSException {
        this.setObject(name, new Boolean(b));
    }

    public void setByte(String name, byte b) throws JMSException {
        this.setObject(name, new Byte(b));
    }

    public void setShort(String name, short s) throws JMSException {
        this.setObject(name, new Short(s));
    }

    public void setInt(String name, int i) throws JMSException {
        this.setObject(name, new Integer(i));
    }

    public void setLong(String name, long l) throws JMSException {
        this.setObject(name, new Long(l));
    }

    public void setFloat(String name, float f) throws JMSException {
        this.setObject(name, new Float(f));
    }

    public void setDouble(String name, double d) throws JMSException {
        this.setObject(name, new Double(d));
    }

    public void setString(String name, String s) throws JMSException {
        this.setObject(name, s);
    }

    public void setChar(String name, char ch) throws JMSException {
        this.setObject(name, new Character(ch));
    }

    public void setBytes(String name, byte[] buf) throws JMSException {
        this.setBytes(name, buf, 0, buf.length);
    }

    public void setBytes(String name, byte[] buf, int offset, int length) throws JMSException {
        byte[] newBuf = new byte[length];
        System.arraycopy(buf, offset, newBuf, 0, length);
        this.setObject(name, newBuf);
    }

    public void setObject(String name, Object obj) throws JMSException {
        this.checkBodyWriteable();
        if (obj != null && !(obj instanceof byte[]) && !obj.getClass().getName().startsWith("java.lang.")) {
            throw new MessageFormatException(L.l("'{0}' is an invalid value for a map message.", (Object)obj.getClass().getName()));
        }
        if (name == null || "".equals(name)) {
            throw new IllegalArgumentException(L.l("MapMessage.setXXX name may not be empty."));
        }
        this._map.put(name, obj);
    }

    public MessageImpl copy() {
        return new MapMessageImpl(this);
    }

    protected void copy(MapMessageImpl newMsg) {
        super.copy(newMsg);
        newMsg._map = new HashMap<String, Object>(this._map);
    }

    public InputStream bodyToInputStream() throws IOException {
        if (this._map == null) {
            return null;
        }
        TempStream body = new TempStream();
        body.openWrite();
        StreamImplOutputStream ws = new StreamImplOutputStream(body);
        Hessian2Output out = new Hessian2Output(ws);
        out.writeObject(this._map);
        out.close();
        ws.close();
        return body.openRead();
    }

    public void readBody(InputStream is) throws IOException, JMSException {
        if (is != null) {
            Hessian2Input in = new Hessian2Input(is);
            this._map = (HashMap)in.readObject();
            in.close();
        }
        this.setBodyReadOnly();
    }

    public String toString() {
        return "MapMessageImpl[]";
    }
}

