/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jms.selector;

import com.caucho.jms.selector.Selector;
import com.caucho.jms.selector.SpecialIdentifierSelector;
import com.caucho.util.IntMap;
import com.caucho.util.L10N;
import java.util.Locale;
import javax.jms.JMSException;
import javax.jms.Message;

public class IdentifierSelector
extends Selector {
    static L10N L = new L10N(Selector.class);
    static final IntMap _specialSelectors = new IntMap();
    private String _name;

    private IdentifierSelector(String name) {
        this._name = name;
    }

    static Selector create(String name) {
        int type = _specialSelectors.get(name.toLowerCase(Locale.ENGLISH));
        if (type >= 0) {
            return new SpecialIdentifierSelector(type);
        }
        return new IdentifierSelector(name);
    }

    Object evaluate(Message message) throws JMSException {
        return message.getObjectProperty(this._name);
    }

    public String toString() {
        return this._name;
    }

    static {
        _specialSelectors.put("jmsdeliverymode", 1);
        _specialSelectors.put("jmspriority", 2);
        _specialSelectors.put("jmsmessageid", 3);
        _specialSelectors.put("jmstimestamp", 4);
        _specialSelectors.put("jmscorrelationid", 5);
        _specialSelectors.put("jmstype", 6);
    }
}

