/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jms.services;

import com.caucho.hessian.io.AbstractHessianOutput;
import com.caucho.hessian.io.Hessian2Input;
import com.caucho.hessian.io.Hessian2Output;
import com.caucho.hessian.io.HessianOutput;
import com.caucho.hessian.io.SerializerFactory;
import com.caucho.hessian.server.HessianSkeleton;
import com.caucho.jms.util.BytesMessageInputStream;
import com.caucho.services.server.GenericService;
import com.caucho.util.NullOutputStream;
import java.io.IOException;
import java.util.logging.Logger;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Session;
import javax.jms.Topic;

public class HessianListener {
    protected static Logger log = Logger.getLogger(HessianListener.class.getName());
    private Class _homeAPI;
    private Object _homeImpl;
    private Class _objectAPI;
    private Object _objectImpl;
    private HessianSkeleton _homeSkeleton;
    private HessianSkeleton _objectSkeleton;
    private SerializerFactory _serializerFactory;
    private int _listenerMax = 5;
    private Connection _jmsConnection;
    private ConnectionFactory _connectionFactory;
    private Destination _destination;
    private Session _jmsSession;

    public void setHomeAPI(Class api) {
        this._homeAPI = api;
    }

    public void setHome(Object home) {
        this._homeImpl = home;
    }

    public void setObjectAPI(Class api) {
        this._objectAPI = api;
    }

    public void setObject(Object object) {
        this._objectImpl = object;
    }

    public void setService(Object service) {
        this.setHome(service);
    }

    public void setAPIClass(Class api) {
        this.setHomeAPI(api);
    }

    public Class getAPIClass() {
        return this._homeAPI;
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this._connectionFactory = connectionFactory;
    }

    public void setDestination(Destination destination) {
        this._destination = destination;
    }

    public void setSerializerFactory(SerializerFactory factory) {
        this._serializerFactory = factory;
    }

    public SerializerFactory getSerializerFactory() {
        if (this._serializerFactory == null) {
            this._serializerFactory = new SerializerFactory();
        }
        return this._serializerFactory;
    }

    public void setSendCollectionType(boolean sendType) {
        this.getSerializerFactory().setSendCollectionType(sendType);
    }

    public void init() {
        if (this._homeImpl == null) {
            this._homeImpl = this;
        }
        if (this._homeImpl != null) {
            this._homeAPI = this.findRemoteAPI(this._homeImpl.getClass());
            if (this._homeAPI == null) {
                this._homeAPI = this._homeImpl.getClass();
            }
        }
        if (this._objectAPI == null && this._objectImpl != null) {
            this._objectAPI = this._objectImpl.getClass();
        }
        this._homeSkeleton = new HessianSkeleton(this._homeImpl, this._homeAPI);
        if (this._objectAPI != null) {
            this._homeSkeleton.setObjectClass(this._objectAPI);
        }
        if (this._objectImpl != null) {
            this._objectSkeleton = new HessianSkeleton(this._objectImpl, this._objectAPI);
            this._objectSkeleton.setHomeClass(this._homeAPI);
        } else {
            this._objectSkeleton = this._homeSkeleton;
        }
    }

    public void start() throws Throwable {
        this._jmsConnection = this._connectionFactory.createConnection();
        if (this._destination instanceof Topic) {
            this._listenerMax = 1;
        }
        for (int i = 0; i < this._listenerMax; ++i) {
            Session session = this._jmsConnection.createSession(false, 1);
            MessageConsumer consumer = session.createConsumer(this._destination);
            consumer.setMessageListener(new HessianListenerMDB());
        }
        this._jmsConnection.start();
    }

    public void stop() throws JMSException {
        this._jmsConnection.stop();
    }

    private Class findRemoteAPI(Class implClass) {
        if (implClass == null || implClass.equals(GenericService.class)) {
            return null;
        }
        Class<?>[] interfaces = implClass.getInterfaces();
        if (interfaces.length == 1) {
            return interfaces[0];
        }
        return this.findRemoteAPI(implClass.getSuperclass());
    }

    private class HessianListenerMDB
    implements MessageListener {
        private HessianListenerMDB() {
        }

        public void onMessage(Message message) {
            try {
                String objectId = message.getStringProperty("id");
                if (!(message instanceof BytesMessage)) {
                    log.info("HessianListener expects only BytesMessages");
                    return;
                }
                BytesMessageInputStream is = new BytesMessageInputStream((BytesMessage)message);
                NullOutputStream os = new NullOutputStream();
                Hessian2Input in = new Hessian2Input(is);
                SerializerFactory serializerFactory = HessianListener.this.getSerializerFactory();
                in.setSerializerFactory(serializerFactory);
                int code = in.read();
                if (code != 99) {
                    throw new IOException("expected 'c' in hessian input at " + code);
                }
                int major = in.read();
                int minor = in.read();
                AbstractHessianOutput out = major >= 2 ? new Hessian2Output(os) : new HessianOutput(os);
                out.setSerializerFactory(serializerFactory);
                if (objectId != null) {
                    HessianListener.this._objectSkeleton.invoke(in, out);
                } else {
                    HessianListener.this._homeSkeleton.invoke(in, out);
                }
                out.close();
            }
            catch (JMSException e) {
                log.warning("Unable to process request: " + e);
            }
            catch (IOException e) {
                log.warning("Unable to process request: " + e);
            }
            catch (Throwable e) {
                log.warning("Unable to process request: " + e);
            }
        }
    }
}

