/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jmx;

import com.caucho.util.L10N;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.management.loading.ClassLoaderRepository;

public class ClassLoaderRepositoryImpl
implements ClassLoaderRepository {
    private static final L10N L = new L10N(ClassLoaderRepositoryImpl.class);
    private static final Logger log = Logger.getLogger(ClassLoaderRepositoryImpl.class.getName());
    private ArrayList<ClassLoader> _loaders = new ArrayList();

    void addClassLoader(ClassLoader loader) {
        this._loaders.add(loader);
    }

    public Class loadClass(String className) throws ClassNotFoundException {
        for (int i = 0; i < this._loaders.size(); ++i) {
            ClassLoader loader = this._loaders.get(i);
            try {
                Class<?> cl = loader.loadClass(className);
                if (cl == null) continue;
                return cl;
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        throw new ClassNotFoundException(L.l("can't load class {0}", (Object)className));
    }

    public Class loadClassBefore(ClassLoader stop, String className) throws ClassNotFoundException {
        ClassLoader loader;
        for (int i = 0; i < this._loaders.size() && (loader = this._loaders.get(i)) != stop; ++i) {
            try {
                Class<?> cl = loader.loadClass(className);
                if (cl == null) continue;
                return cl;
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        throw new ClassNotFoundException(L.l("can't load class {0}", (Object)className));
    }

    public Class loadClassWithout(ClassLoader exclude, String className) throws ClassNotFoundException {
        for (int i = 0; i < this._loaders.size(); ++i) {
            ClassLoader loader = this._loaders.get(i);
            if (loader == exclude) continue;
            try {
                Class<?> cl = loader.loadClass(className);
                if (cl == null) continue;
                return cl;
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        throw new ClassNotFoundException(L.l("can't load class {0}", (Object)className));
    }
}

