/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jsmp;

import com.caucho.bam.actor.ActorHolder;
import com.caucho.bam.broker.AbstractBroker;
import com.caucho.bam.broker.Broker;
import com.caucho.bam.mailbox.Mailbox;
import com.caucho.bam.stream.AbstractMessageStream;
import com.caucho.bam.stream.MessageStream;
import com.caucho.config.ConfigException;
import com.caucho.jsmp.JsmpReader;
import com.caucho.jsmp.JsmpWriter;
import com.caucho.util.L10N;
import com.caucho.websocket.AbstractWebSocketListener;
import com.caucho.websocket.WebSocketContext;
import com.caucho.websocket.WebSocketServletRequest;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.logging.Logger;
import javax.servlet.GenericServlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JmtpServlet
extends GenericServlet {
    private static final L10N L = new L10N(JmtpServlet.class);
    private static final Logger log = Logger.getLogger(JmtpServlet.class.getName());
    private Class<?> _actorClass;

    public void setActorClass(Class<?> actorClass) {
        this._actorClass = actorClass;
    }

    @Override
    public void init() {
        if (this._actorClass == null) {
            throw new ConfigException(L.l("JmtpServlet requires an actor"));
        }
    }

    @Override
    public void service(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        ActorHolder actor;
        WebSocketServletRequest wsRequest = (WebSocketServletRequest)((Object)request);
        try {
            actor = (ActorHolder)this._actorClass.newInstance();
        }
        catch (Exception e) {
            throw new ServletException(e);
        }
        Listener listener = new Listener(actor);
        wsRequest.startWebSocket(listener);
    }

    private static class JmtpMailbox
    extends AbstractMessageStream
    implements Mailbox {
        private Listener _listener;

        JmtpMailbox(Listener listener) {
            this._listener = listener;
        }

        public Broker getBroker() {
            return this._listener._jmtpBroker;
        }

        public int getSize() {
            return -1;
        }

        public MessageStream getActorStream() {
            return null;
        }

        public void close() {
        }
    }

    private static class JmtpBroker
    extends AbstractBroker {
        private Listener _listener;

        JmtpBroker(Listener listener) {
            this._listener = listener;
        }

        public Mailbox getMailbox(String address) {
            return this._listener._jmtpMailbox;
        }
    }

    static class Listener
    extends AbstractWebSocketListener {
        private ActorHolder _actor;
        private MessageStream _actorStream;
        private InputStream _is;
        private OutputStream _os;
        private JsmpReader _jmtpReader;
        private JsmpWriter _jmtpWriter;
        private JmtpMailbox _jmtpMailbox;
        private JmtpBroker _jmtpBroker;

        Listener(ActorHolder actor) {
            this._actor = actor;
            if (this._actor == null) {
                throw new NullPointerException();
            }
        }

        public void onStart(WebSocketContext context) throws IOException {
            this._jmtpMailbox = new JmtpMailbox(this);
            this._actor.setBroker(new JmtpBroker(this));
            this._actorStream = this._actor.getActor();
        }

        public void onReadBinary(WebSocketContext context, InputStream is) throws IOException {
            JsmpReader reader = new JsmpReader(is);
            reader.readPacket(this._actorStream);
        }

        public void onReadText(WebSocketContext context, Reader is) throws IOException {
        }
    }
}

