/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.json.ser;

import com.caucho.json.JsonOutput;
import com.caucho.json.ser.AbstractJsonSerializer;
import com.caucho.json.ser.JsonSerializer;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DoubleSerializer
extends AbstractJsonSerializer<Number> {
    static final JsonSerializer SER = new DoubleSerializer();

    private DoubleSerializer() {
    }

    @Override
    public void write(JsonOutput out, Number value, boolean annotated) throws IOException {
        double dValue = value.doubleValue();
        if (Double.isNaN(dValue)) {
            out.writeDouble(0.0);
        } else if (Double.isInfinite(dValue)) {
            if (dValue > 0.0) {
                out.writeDouble(Double.MAX_VALUE);
            } else {
                out.writeDouble(-1.7976931348623157E308);
            }
        } else {
            out.writeDouble(value.doubleValue());
        }
    }
}

