/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.json.ser;

import com.caucho.json.Json;
import com.caucho.json.JsonOutput;
import com.caucho.json.Transient;
import com.caucho.json.ser.AbstractJsonSerializer;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaSerializer
extends AbstractJsonSerializer {
    private static final Logger log = Logger.getLogger(JavaSerializer.class.getName());
    private Class _type;
    private JsonField[] _fields;

    JavaSerializer(Class type, boolean annotated) {
        this._type = type;
        this.introspect(annotated);
    }

    void introspect(boolean annotated) {
        ArrayList<JsonField> fields = new ArrayList<JsonField>();
        this.introspectFields(fields, this._type, annotated);
        Collections.sort(fields, new JsonFieldComparator());
        this._fields = new JsonField[fields.size()];
        fields.toArray(this._fields);
    }

    private void introspectFields(ArrayList<JsonField> fields, Class type, boolean annotated) {
        if (type == null) {
            return;
        }
        this.introspectFields(fields, type.getSuperclass(), annotated);
        for (Field field : type.getDeclaredFields()) {
            if (Modifier.isTransient(field.getModifiers()) || Modifier.isStatic(field.getModifiers()) || annotated && field.getAnnotation(Transient.class) != null) continue;
            field.setAccessible(true);
            Json json = field.getAnnotation(Json.class);
            JsonField jsonField = new JsonField(field, json);
            fields.add(jsonField);
        }
    }

    @Override
    public void write(JsonOutput out, Object value, boolean annotated) throws IOException {
        int i = 0;
        out.writeMapBegin();
        for (JsonField field : this._fields) {
            Object fieldValue = null;
            try {
                fieldValue = field.getField().get(value);
            }
            catch (Exception e) {
                log.warning(out + " cannot get field " + field + " with value " + value);
            }
            if (fieldValue == null) continue;
            if (i++ > 0) {
                out.writeMapComma();
            }
            out.writeMapEntry(field.getName(), fieldValue, annotated);
        }
        out.writeMapEnd();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class JsonFieldComparator
    implements Comparator<JsonField> {
        JsonFieldComparator() {
        }

        @Override
        public int compare(JsonField a, JsonField b) {
            return a.getName().compareTo(b.getName());
        }
    }

    static class JsonField {
        private Field _field;
        private String name;

        JsonField(Field field, Json json) {
            this._field = field;
            this.name = json != null ? json.name() : this._field.getName();
        }

        public Field getField() {
            return this._field;
        }

        public String getName() {
            return this.name;
        }
    }
}

