/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jsp.java;

import com.caucho.jsp.JspParseException;
import com.caucho.jsp.java.CustomSimpleTag;
import com.caucho.jsp.java.CustomTag;
import com.caucho.jsp.java.JspAttribute;
import com.caucho.jsp.java.JspBody;
import com.caucho.jsp.java.JspExpression;
import com.caucho.jsp.java.JspJavaWriter;
import com.caucho.jsp.java.JspNode;
import com.caucho.jsp.java.JspRoot;
import com.caucho.jsp.java.StaticText;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.caucho.util.LineCompileException;
import com.caucho.vfs.WriteStream;
import com.caucho.xml.QName;
import com.caucho.xml.XmlChar;
import java.io.IOException;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JspContainerNode
extends JspNode {
    static final L10N L = new L10N(JspContainerNode.class);
    protected ArrayList<QName> _attributeNames = new ArrayList();
    protected ArrayList<Object> _attributeValues = new ArrayList();
    protected ArrayList<JspNode> _children = new ArrayList();
    private ArrayList<JspAttribute> _attrChildren;
    protected boolean _hasJspAttribute;

    @Override
    public void addAttribute(QName name, String value) throws JspParseException {
        if (name == null) {
            throw new NullPointerException();
        }
        if (this._attributeNames.indexOf(name) >= 0) {
            throw this.error(L.l("'{0}' is a duplicate attribute name.  Attributes must occur only once in a tag.", (Object)name.getName()));
        }
        this._attributeNames.add(name);
        this._attributeValues.add(value);
    }

    @Override
    public void addAttribute(QName name, JspAttribute value) throws JspParseException {
        if (name == null) {
            throw new NullPointerException();
        }
        if (this._attributeNames.indexOf(name) >= 0) {
            throw this.error(L.l("'{0}' is a duplicate attribute name.  Attributes must occur only once in a tag.", (Object)name.getName()));
        }
        this._attributeNames.add(name);
        this._attributeValues.add(value);
        this._gen.addFragment(value);
    }

    public Object getAttribute(String name) throws JspParseException {
        for (int i = 0; i < this._attributeNames.size(); ++i) {
            if (!name.equals(this._attributeNames.get(i).getName())) continue;
            return this._attributeValues.get(i);
        }
        return null;
    }

    @Override
    public void addChild(JspNode node) throws JspParseException {
        node.setParent(this);
        if (node instanceof JspAttribute) {
            JspAttribute attr = (JspAttribute)node;
            QName name = attr.getName();
            this.addAttribute(name, attr);
            this._hasJspAttribute = true;
            int i = 0;
            while (this._children != null && i < this._children.size()) {
                JspNode child = this._children.get(i);
                if (child instanceof StaticText) {
                    String text = ((StaticText)child).getText();
                    if (this.isWhitespace(text)) {
                        this._children.remove(i);
                        continue;
                    }
                    throw child.error(L.l("tags using jsp:attribute must put body content in a jsp:body tag."));
                }
                if (child instanceof JspBody) {
                    ++i;
                    continue;
                }
                if (child instanceof JspAttribute) {
                    ++i;
                    continue;
                }
                throw child.error(L.l("tags using jsp:attribute must put body content in a jsp:body tag"));
            }
        } else {
            if (this._hasJspAttribute && !(node instanceof JspBody)) {
                throw node.error(L.l("tags using jsp:attribute must put body content in a jsp:body tag"));
            }
            if (node instanceof StaticText) {
                StaticText text = (StaticText)node;
                String data = text.getText();
                boolean isXml = this._gen.isXml();
                for (JspNode ptr = this; ptr != null; ptr = ptr.getParent()) {
                    if (!(ptr instanceof JspRoot)) continue;
                    isXml = true;
                }
                if (this._children == null) {
                    this._children = new ArrayList();
                }
                for (int i = 0; i < data.length(); ++i) {
                    if (XmlChar.isWhitespace(data.charAt(i))) continue;
                    this._children.add(node);
                    return;
                }
                if (!isXml) {
                    this._children.add(node);
                }
            } else {
                if (node instanceof JspBody && this.hasJspBody()) {
                    throw node.error(L.l("tags may only have a single jsp:body tag"));
                }
                if (this._children == null) {
                    this._children = new ArrayList();
                }
                this._children.add(node);
            }
        }
    }

    protected void addAttributeChild(JspAttribute attr) {
        if (this._attrChildren == null) {
            this._attrChildren = new ArrayList();
        }
        this._attrChildren.add(attr);
    }

    private boolean hasJspBody() {
        if (this._children == null) {
            return false;
        }
        for (int i = this._children.size() - 1; i >= 0; --i) {
            if (!(this._children.get(i) instanceof JspBody)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addChildEnd(JspNode node) throws JspParseException {
    }

    @Override
    public boolean isJsfParentRequired() {
        if (this._children == null) {
            return false;
        }
        for (int i = this._children.size() - 1; i >= 0; --i) {
            if (!this._children.get(i).isJsfParentRequired()) continue;
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        if (this._children == null || this._children.size() == 0) {
            return true;
        }
        for (int i = 0; i < this._children.size(); ++i) {
            JspNode child = this._children.get(i);
            if (child instanceof JspBody) {
                JspBody body = (JspBody)child;
                return body.isEmpty();
            }
            if (child instanceof StaticText) {
                StaticText text = (StaticText)child;
                if (text.isWhitespace()) continue;
                return false;
            }
            return false;
        }
        return false;
    }

    @Override
    public void getStaticText(CharBuffer cb) {
        if (this._children == null) {
            return;
        }
        for (int i = 0; i < this._children.size(); ++i) {
            this._children.get(i).getStaticText(cb);
        }
    }

    @Override
    public boolean hasCustomTag() {
        int i;
        for (i = 0; this._children != null && i < this._children.size(); ++i) {
            JspNode child = this._children.get(i);
            if (child instanceof CustomTag) {
                return true;
            }
            if (!child.hasCustomTag()) continue;
            return true;
        }
        for (i = 0; this._attributeValues != null && i < this._attributeValues.size(); ++i) {
            Object value = this._attributeValues.get(i);
            if (value instanceof CustomTag) {
                return true;
            }
            if (!(value instanceof JspNode) || !((JspNode)value).hasCustomTag()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasTag() {
        int i;
        for (i = 0; this._children != null && i < this._children.size(); ++i) {
            JspNode child = this._children.get(i);
            if (child instanceof CustomTag || child instanceof CustomSimpleTag) {
                return true;
            }
            if (!child.hasTag()) continue;
            return true;
        }
        for (i = 0; this._attributeValues != null && i < this._attributeValues.size(); ++i) {
            Object value = this._attributeValues.get(i);
            if (value instanceof CustomTag || value instanceof CustomSimpleTag) {
                return true;
            }
            if (!(value instanceof JspNode) || !((JspNode)value).hasTag()) continue;
            return true;
        }
        return false;
    }

    @Override
    public JspNode addText(String text) throws JspParseException {
        if (!this._hasJspAttribute) {
            StaticText node = new StaticText(this._gen, text, this);
            this.addChild(node);
            return node;
        }
        if (!this.isWhitespace(text)) {
            throw this.error(L.l("tags using jsp:attribute must put body content in a jsp:body tag"));
        }
        return null;
    }

    protected boolean isWhitespace(String text) {
        for (int i = 0; i < text.length(); ++i) {
            if (Character.isWhitespace(text.charAt(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public ArrayList<JspNode> getChildren() {
        return this._children;
    }

    public boolean hasChildren() {
        return !this.isEmpty();
    }

    @Override
    public boolean hasScripting() {
        for (int i = 0; this._children != null && i < this._children.size(); ++i) {
            if (!this._children.get(i).hasScripting()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasScriptingElement() {
        for (int i = 0; this._children != null && i < this._children.size(); ++i) {
            if (!this._children.get(i).hasScriptingElement()) continue;
            return true;
        }
        return false;
    }

    @Override
    public JspNode findScriptingNode() {
        for (int i = 0; this._children != null && i < this._children.size(); ++i) {
            JspNode node = this._children.get(i).findScriptingNode();
            if (node == null) continue;
            return node;
        }
        if (this.hasScripting()) {
            return this;
        }
        return null;
    }

    public boolean isSingleExpression() {
        for (int i = 0; this._children != null && i < this._children.size(); ++i) {
            JspNode node = this._children.get(i);
            if (node instanceof JspExpression || node.isStatic() && node.getStaticText().trim().length() == 0) continue;
            return false;
        }
        return true;
    }

    public boolean isChildrenStatic() {
        if (this._children == null) {
            return true;
        }
        for (int i = 0; i < this._children.size(); ++i) {
            if (this._children.get(i).isStatic()) continue;
            return false;
        }
        return true;
    }

    public void printXmlChildren(WriteStream os) throws IOException {
        if (this._children == null) {
            return;
        }
        for (int i = 0; i < this._children.size(); ++i) {
            JspNode child = this._children.get(i);
            child.printXml(os);
        }
    }

    @Override
    public void generatePrologueChildren(JspJavaWriter out) throws Exception {
        if (this._children == null) {
            return;
        }
        for (int i = 0; i < this._children.size(); ++i) {
            JspNode child = this._children.get(i);
            child.generatePrologue(out);
        }
    }

    @Override
    public void generateDeclarationChildren(JspJavaWriter out) throws IOException {
        if (this._children == null) {
            return;
        }
        for (int i = 0; i < this._children.size(); ++i) {
            JspNode child = this._children.get(i);
            child.generateDeclaration(out);
        }
    }

    @Override
    public void generateTagStateChildren(JspJavaWriter out) throws Exception {
        if (this._children != null) {
            for (int i = 0; i < this._children.size(); ++i) {
                JspNode jspNode = this._children.get(i);
                jspNode.generateTagState(out);
            }
        }
        if (this._attrChildren != null) {
            for (JspAttribute jspAttribute : this._attrChildren) {
                jspAttribute.generateTagState(out);
            }
        }
    }

    @Override
    public void generateTagReleaseChildren(JspJavaWriter out) throws Exception {
        if (this._children != null) {
            for (int i = 0; i < this._children.size(); ++i) {
                JspNode jspNode = this._children.get(i);
                jspNode.generateTagRelease(out);
            }
        }
        if (this._attrChildren != null) {
            for (JspAttribute jspAttribute : this._attrChildren) {
                jspAttribute.generateTagRelease(out);
            }
        }
    }

    @Override
    public void generateChildren(JspJavaWriter out) throws Exception {
        if (this._children == null) {
            return;
        }
        for (int i = 0; i < this._children.size(); ++i) {
            JspNode child = this._children.get(i);
            child.generateStartLocation(out);
            try {
                child.generate(out);
            }
            catch (Exception e) {
                if (e instanceof LineCompileException) {
                    throw e;
                }
                throw child.error(e);
            }
            child.generateEndLocation(out);
        }
    }

    @Override
    public void generateChildrenEmpty() throws Exception {
        if (this._children == null) {
            return;
        }
        for (int i = 0; i < this._children.size(); ++i) {
            JspNode child = this._children.get(i);
            child.generateEmpty();
        }
    }

    @Override
    public void generateStatic(JspJavaWriter out) throws Exception {
        if (this._children == null) {
            return;
        }
        for (int i = 0; i < this._children.size(); ++i) {
            JspNode child = this._children.get(i);
            out.setLocation(child.getFilename(), child.getStartLine());
            child.generateStatic(out);
        }
    }

    @Override
    public void generateClassEpilogueChildren(JspJavaWriter out) throws IOException {
        if (this._children != null) {
            for (int i = 0; i < this._children.size(); ++i) {
                JspNode jspNode = this._children.get(i);
                jspNode.generateClassEpilogue(out);
            }
        }
        if (this._attrChildren != null) {
            for (JspAttribute jspAttribute : this._attrChildren) {
                jspAttribute.generateClassEpilogue(out);
            }
        }
    }
}

