/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jsp.jsf;

import com.caucho.util.L10N;
import java.util.List;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.component.html.HtmlOutputText;
import javax.faces.context.FacesContext;
import javax.faces.webapp.UIComponentClassicTagBase;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.tagext.BodyContent;

public class JsfTagUtil {
    private static final L10N L = new L10N(JsfTagUtil.class);

    public static UIViewRoot findRoot(FacesContext context, ServletRequest req, Object etag) throws Exception {
        UIViewRoot root;
        if (context == null) {
            context = FacesContext.getCurrentInstance();
        }
        if ((root = context.getViewRoot()) == null) {
            throw new NullPointerException(L.l("f:view can't find current in FacesContext"));
        }
        Object oldETag = root.getAttributes().get("caucho.etag");
        if (oldETag != null && !oldETag.equals(etag)) {
            root.getChildren().clear();
            root.getFacets().clear();
        }
        root.getAttributes().put("caucho.etag", etag);
        return root;
    }

    public static void afterRoot(FacesContext context, HttpServletRequest req, HttpServletResponse res) {
        HttpSession session = req.getSession(false);
        if (session != null) {
            session.setAttribute("javax.faces.request.charset", res.getCharacterEncoding());
        }
    }

    public static UIComponent addTransient(FacesContext context, ServletRequest req, UIComponent parent, String prevId, Class childClass) throws Exception {
        UIComponent child;
        if (context == null) {
            context = FacesContext.getCurrentInstance();
        }
        if (parent == null) {
            UIComponentClassicTagBase parentTag = (UIComponentClassicTagBase)req.getAttribute("caucho.jsf.parent");
            parent = parentTag.getComponentInstance();
            BodyContent body = parentTag.getBodyContent();
            if (body != null) {
                JsfTagUtil.addVerbatim(parent, body);
            }
        }
        if ((child = null) == null) {
            child = (UIComponent)childClass.newInstance();
        }
        child.setTransient(true);
        JsfTagUtil.addChild(parent, prevId, child);
        return child;
    }

    public static UIComponent addVerbatim(UIComponent parent, String prevId, String text) throws Exception {
        HtmlOutputText verbatim = new HtmlOutputText();
        verbatim.setTransient(true);
        verbatim.setValue((Object)text);
        verbatim.setEscape(false);
        JsfTagUtil.addChild(parent, prevId, (UIComponent)verbatim);
        return verbatim;
    }

    public static UIComponent addVerbatim(UIComponent parent, String text) throws Exception {
        HtmlOutputText verbatim = new HtmlOutputText();
        verbatim.setTransient(true);
        verbatim.setValue((Object)text);
        verbatim.setEscape(false);
        parent.getChildren().add(verbatim);
        return verbatim;
    }

    private static void addChild(UIComponent parent, String prevId, UIComponent child) {
        if (parent != null) {
            List children = parent.getChildren();
            int size = children.size();
            boolean hasPrev = prevId == null;
            for (int i = 0; i < size; ++i) {
                UIComponent oldChild = (UIComponent)children.get(i);
                if (hasPrev && oldChild.getId() != null) {
                    children.add(i, child);
                    return;
                }
                if (prevId == null || !prevId.equals(oldChild.getId())) continue;
                hasPrev = true;
            }
            parent.getChildren().add(child);
        }
    }

    public static UIComponent findPersistent(FacesContext context, ServletRequest req, UIComponent parent, String id) throws Exception {
        if (context == null) {
            context = FacesContext.getCurrentInstance();
        }
        BodyContent body = null;
        if (parent == null) {
            UIComponentClassicTagBase parentTag = (UIComponentClassicTagBase)req.getAttribute("caucho.jsf.parent");
            parent = parentTag.getComponentInstance();
            body = parentTag.getBodyContent();
        }
        if (parent != null) {
            List children = parent.getChildren();
            int size = children.size();
            String prevId = null;
            for (int i = 0; i < size; ++i) {
                UIComponent child = (UIComponent)children.get(i);
                if (id.equals(child.getId())) {
                    if (body != null) {
                        JsfTagUtil.addVerbatim(parent, prevId, body);
                    }
                    return child;
                }
                if (child.getId() == null) continue;
                prevId = child.getId();
            }
        }
        return null;
    }

    public static UIComponent addPersistent(FacesContext context, ServletRequest req, UIComponent parent, ValueExpression binding, Class childClass) throws Exception {
        if (context == null) {
            context = FacesContext.getCurrentInstance();
        }
        if (parent == null) {
            UIComponentClassicTagBase parentTag = (UIComponentClassicTagBase)req.getAttribute("caucho.jsf.parent");
            parent = parentTag.getComponentInstance();
            BodyContent body = parentTag.getBodyContent();
            JsfTagUtil.addVerbatim(parent, body);
        }
        UIComponent child = null;
        if (binding != null) {
            child = (UIComponent)binding.getValue(context.getELContext());
        }
        if (child == null) {
            child = (UIComponent)childClass.newInstance();
            if (binding != null) {
                binding.setValue(context.getELContext(), child);
            }
        }
        if (parent != null) {
            parent.getChildren().add(child);
        }
        return child;
    }

    public static UIComponent addVerbatim(UIComponent parent, String prevId, BodyContent body) throws Exception {
        String value = body.getString();
        body.clear();
        if (!JsfTagUtil.isWhitespace(value)) {
            return JsfTagUtil.addVerbatim(parent, prevId, value);
        }
        return null;
    }

    public static UIComponent addVerbatim(UIComponent parent, BodyContent body) throws Exception {
        String value = body.getString();
        body.clear();
        if (!JsfTagUtil.isWhitespace(value)) {
            return JsfTagUtil.addVerbatim(parent, value);
        }
        return null;
    }

    private static boolean isWhitespace(String text) {
        if (text == null) {
            return true;
        }
        boolean isWhitespace = true;
        for (int i = text.length() - 1; i >= 0; --i) {
            int head;
            char ch = text.charAt(i);
            if (Character.isWhitespace(ch)) continue;
            if (ch == '>' && text.indexOf("-->") + 2 == i && (head = text.indexOf("<!--")) >= 0) {
                for (int j = 0; j < head; ++j) {
                    if (Character.isWhitespace(text.charAt(j))) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        return true;
    }

    public static UIComponent findFacet(FacesContext context, ServletRequest req, UIComponent parent, String facetName) throws Exception {
        if (context == null) {
            FacesContext.getCurrentInstance();
        }
        if (parent == null) {
            UIComponentClassicTagBase parentTag = (UIComponentClassicTagBase)req.getAttribute("caucho.jsf.parent");
            parent = parentTag.getComponentInstance();
        }
        if (parent != null) {
            return parent.getFacet(facetName);
        }
        return null;
    }

    public static UIComponent addFacet(FacesContext context, ServletRequest req, UIComponent parent, String facetName, ValueExpression binding, Class childClass) throws Exception {
        if (context == null) {
            context = FacesContext.getCurrentInstance();
        }
        if (parent == null) {
            UIComponentClassicTagBase parentTag = (UIComponentClassicTagBase)req.getAttribute("caucho.jsf.parent");
            parent = parentTag.getComponentInstance();
        }
        UIComponent child = null;
        if (binding != null) {
            child = (UIComponent)binding.getValue(context.getELContext());
        }
        if (child == null) {
            child = (UIComponent)childClass.newInstance();
        }
        if (parent != null) {
            parent.getFacets().put(facetName, child);
        }
        if (binding != null) {
            binding.setValue(context.getELContext(), child);
        }
        return child;
    }
}

