/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jstl.rt;

import com.caucho.jstl.el.ForEachTag;
import com.caucho.jstl.rt.CoreStringTokenValueExpression;
import com.caucho.util.EnumIterator;
import com.caucho.util.L10N;
import com.caucho.util.NullIterator;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import javax.el.ValueExpression;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.jstl.core.IndexedValueExpression;
import javax.servlet.jsp.jstl.core.IteratedExpression;
import javax.servlet.jsp.jstl.core.IteratedValueExpression;
import javax.servlet.jsp.jstl.core.LoopTagSupport;

public class CoreForEachTag
extends LoopTagSupport {
    private static final L10N L = new L10N(CoreForEachTag.class);
    protected int _begin;
    protected int _end;
    protected Object _items;
    protected boolean _hasItems;
    protected Iterator _iterator;

    public void setItems(Object items) {
        this._items = items;
        this._hasItems = true;
    }

    public void setBegin(int begin) {
        this._begin = begin;
        this.begin = begin;
        this.beginSpecified = true;
    }

    public void setEnd(int end) {
        this._end = end;
        this.end = end;
        this.endSpecified = true;
    }

    public void setStep(int step) {
        this.step = step;
        this.stepSpecified = true;
    }

    public void prepare() throws JspTagException {
        if (this._items instanceof ValueExpression) {
            this.deferredExpression = (ValueExpression)this._items;
            this._items = this.deferredExpression.getValue(this.pageContext.getELContext());
        }
        this._iterator = this._hasItems ? ForEachTag.getIterator(this._items) : new RangeIterator(0, this._end);
    }

    public boolean hasNext() {
        return this._iterator.hasNext();
    }

    public Object next() {
        return this._iterator.next();
    }

    public static Iterator getIterator(Object items) throws JspTagException {
        if (items == null) {
            return NullIterator.create();
        }
        if (items instanceof Map) {
            return ((Map)items).entrySet().iterator();
        }
        if (items instanceof Collection) {
            return ((Collection)items).iterator();
        }
        if (items.getClass().isArray()) {
            return new ArrayIterator(items);
        }
        if (items instanceof Iterator) {
            return (Iterator)items;
        }
        if (items instanceof Enumeration) {
            return new EnumIterator((Enumeration)items);
        }
        if (items instanceof String) {
            return new StringIterator((String)items);
        }
        throw new JspTagException(L.l("unknown items value `{0}'", items));
    }

    protected ValueExpression createIndexedExpression(int index) throws JspTagException {
        return CoreForEachTag.getExpr(this.deferredExpression, index, this._items, this.getDelims());
    }

    protected String getDelims() {
        return ",";
    }

    public static ValueExpression getExpr(ValueExpression expr, Integer i, Object items, String delims) throws JspTagException {
        if (items == null) {
            return expr;
        }
        if (items instanceof Collection) {
            return new IndexedValueExpression(expr, i);
        }
        if (items.getClass().isArray()) {
            return new IndexedValueExpression(expr, i);
        }
        if (items instanceof Map) {
            return new IteratedValueExpression(new IteratedExpression(expr, null), i);
        }
        if (items instanceof Iterator) {
            return new IteratedValueExpression(new IteratedExpression(expr, null), i);
        }
        if (items instanceof Enumeration) {
            return new IteratedValueExpression(new IteratedExpression(expr, null), i);
        }
        if (items instanceof String && delims == null) {
            return new IteratedValueExpression(new IteratedExpression(expr, null), i);
        }
        if (items instanceof String && delims != null) {
            return new CoreStringTokenValueExpression(expr, i, delims);
        }
        throw new JspTagException(L.l("unknown items value '{0}'", items));
    }

    public static class RangeIterator
    implements Iterator {
        private int _end;
        private int _i;

        RangeIterator(int begin, int end) {
            this._i = begin;
            this._end = end;
        }

        public boolean hasNext() {
            return this._i <= this._end;
        }

        public Object next() {
            if (this._i <= this._end) {
                return new Integer(this._i++);
            }
            return null;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static class StringIterator
    implements Iterator {
        private String _value;
        private int _length;
        private int _i;
        private StringBuilder _cb = new StringBuilder();

        StringIterator(String value) {
            this._value = value;
            this._length = value.length();
            this._i = 0;
            while (this._i < this._value.length() && this._value.charAt(this._i) == ',') {
                ++this._i;
            }
        }

        public boolean hasNext() {
            return this._i < this._length;
        }

        public Object next() {
            int begin = this._i;
            int tail = -1;
            while (this._i < this._length) {
                char ch = this._value.charAt(this._i);
                if (ch == ',') {
                    if (tail == -1) {
                        tail = this._i;
                    }
                } else if (tail != -1) break;
                ++this._i;
            }
            if (tail == -1) {
                tail = this._length;
            }
            String value = this._value.substring(begin, tail);
            return value;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static class ArrayIterator
    implements Iterator {
        private Object _array;
        private int _index;
        private int _length;

        ArrayIterator(Object array) {
            this._array = array;
            this._length = Array.getLength(array);
        }

        public boolean hasNext() {
            return this._index < this._length;
        }

        public Object next() {
            if (this._index < this._length) {
                return Array.get(this._array, this._index++);
            }
            return null;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

