/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jstl.rt;

import com.caucho.jsp.BodyContentImpl;
import com.caucho.jsp.PageContextImpl;
import com.caucho.jstl.rt.CoreSetTag;
import com.caucho.util.L10N;
import com.caucho.vfs.TempCharReader;
import com.caucho.vfs.Vfs;
import java.io.Reader;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyTagSupport;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.XMLFilter;
import org.xml.sax.XMLReader;

public class XmlParseTag
extends BodyTagSupport {
    private static L10N L = new L10N(XmlParseTag.class);
    private Object _xml;
    private String _systemId;
    private Object _filter;
    private String _var;
    private String _scope;
    private String _varDom;
    private String _scopeDom;

    public void setXml(Object xml) {
        this._xml = xml;
    }

    public void setDoc(Object xml) {
        this.setXml(xml);
    }

    public void setSystemId(String systemId) {
        this._systemId = systemId;
    }

    public void setFilter(Object filter) {
        this._filter = filter;
    }

    public void setVar(String var) {
        this._var = var;
    }

    public void setScope(String scope) {
        this._scope = scope;
    }

    public void setVarDom(String var) {
        this._varDom = var;
    }

    public void setScopeDom(String scope) {
        this._scopeDom = scope;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int doEndTag() throws JspException {
        try {
            InputSource is;
            PageContextImpl pageContext = (PageContextImpl)this.pageContext;
            BodyContentImpl body = (BodyContentImpl)this.getBodyContent();
            XMLReader xmlReader = null;
            Reader reader = null;
            if (this._xml != null) {
                Object obj = this._xml;
                if (obj instanceof Reader) {
                    reader = (Reader)obj;
                    is = new InputSource(reader);
                } else if (obj instanceof String) {
                    reader = Vfs.openString((String)obj).getReader();
                    is = new InputSource(reader);
                } else {
                    if (!(obj instanceof XMLReader)) throw new JspException(L.l("xml must be java.io.Reader, String or org.xml.sax.XMLReader at `{0}'", obj));
                    xmlReader = (XMLReader)obj;
                    is = new InputSource();
                }
            } else {
                int ch;
                if (body == null) throw new JspException(L.l("No XML document supplied via a doc attribute or inside the body of <x:parse> tag."));
                TempCharReader tempReader = (TempCharReader)body.getReader();
                while (Character.isWhitespace(ch = tempReader.read())) {
                }
                if (ch >= 0) {
                    tempReader.unread();
                }
                reader = tempReader;
                is = new InputSource(reader);
            }
            if (this._systemId != null && is != null) {
                is.setSystemId(this._systemId);
            }
            XMLFilter filter = (XMLFilter)this._filter;
            if (xmlReader == null) {
                SAXParserFactory parserFactory = SAXParserFactory.newInstance();
                parserFactory.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
                parserFactory.setFeature("http://xml.org/sax/features/namespaces", true);
                xmlReader = parserFactory.newSAXParser().getXMLReader();
            }
            if (this._filter != null && this._var == null && this._varDom == null) {
                filter.setParent(xmlReader);
                filter.parse(is);
                return 6;
            } else {
                DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
                domFactory.setNamespaceAware(true);
                DocumentBuilder builder = domFactory.newDocumentBuilder();
                Document doc = builder.newDocument();
                SAXTransformerFactory saxFactory = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
                TransformerHandler handler = saxFactory.newTransformerHandler();
                handler.setResult(new DOMResult(doc));
                if (filter != null) {
                    filter.setParent(xmlReader);
                    filter.setContentHandler(handler);
                    filter.parse(is);
                } else {
                    xmlReader.setContentHandler(handler);
                    xmlReader.parse(is);
                }
                if (this._var == null && this._varDom == null) {
                    throw new JspException(L.l("x:parse needs either var or varDom"));
                }
                if (this._var != null) {
                    CoreSetTag.setValue(pageContext, this._var, this._scope, doc);
                }
                if (this._varDom != null) {
                    CoreSetTag.setValue(pageContext, this._varDom, this._scopeDom, doc);
                }
                if (reader == null) return 6;
                reader.close();
            }
            return 6;
        }
        catch (JspException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JspException(e);
        }
    }
}

