/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.make;

import com.caucho.vfs.Dependency;
import com.caucho.vfs.PersistentDependency;
import java.util.ArrayList;
import java.util.logging.Logger;

public class DependencyList
implements PersistentDependency {
    private ArrayList<PersistentDependency> _dependencyList = new ArrayList();

    public DependencyList add(PersistentDependency dependency) {
        if (dependency == this) {
            throw new IllegalArgumentException("Can't add self as a dependency.");
        }
        if (!this._dependencyList.contains(dependency)) {
            this._dependencyList.add(dependency);
        }
        return this;
    }

    public DependencyList remove(PersistentDependency dependency) {
        if (dependency == this) {
            throw new IllegalArgumentException("Can't remove self as a dependency.");
        }
        this._dependencyList.remove(dependency);
        return this;
    }

    public boolean isModified() {
        for (int i = this._dependencyList.size() - 1; i >= 0; --i) {
            Dependency dependency = this._dependencyList.get(i);
            if (!dependency.isModified()) continue;
            return true;
        }
        return false;
    }

    public boolean logModified(Logger log) {
        for (int i = this._dependencyList.size() - 1; i >= 0; --i) {
            Dependency dependency = this._dependencyList.get(i);
            if (!dependency.logModified(log)) continue;
            return true;
        }
        return false;
    }

    public boolean isModifiedNow() {
        return this.isModified();
    }

    public String getJavaCreateString() {
        StringBuilder sb = new StringBuilder();
        sb.append("new com.caucho.make.DependencyList()");
        for (int i = 0; i < this._dependencyList.size(); ++i) {
            sb.append(".add(");
            sb.append(this._dependencyList.get(i).getJavaCreateString());
            sb.append(")");
        }
        return sb.toString();
    }

    public String toString() {
        return "DependencyList" + this._dependencyList;
    }
}

