/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.message.nautilus;

import com.caucho.cloud.network.NetworkClusterSystem;
import com.caucho.cloud.topology.CloudServer;
import com.caucho.distcache.ClusterCache;
import com.caucho.message.broker.AbstractMessageBroker;
import com.caucho.util.CurrentTime;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;

class NautilusBrokerStore
extends AbstractMessageBroker {
    private static final Logger log = Logger.getLogger(NautilusBrokerStore.class.getName());
    private AtomicLong _qidGen = new AtomicLong();
    private ClusterCache _queueCache;

    NautilusBrokerStore() {
        long serverId = 0L;
        try {
            CloudServer server = NetworkClusterSystem.getCurrentSelfServer();
            serverId = server.getIndex();
        }
        catch (Exception e) {
            log.log(Level.FINER, e.toString(), e);
        }
        long seq = (serverId << 56) + (CurrentTime.getCurrentTime() << 24);
        this._qidGen.set(seq);
        this._queueCache = new ClusterCache();
        this._queueCache.setName("resin.message.nautilus");
        this._queueCache.setAccessedExpireTimeoutMillis(0x3FFFFFFFFFFFFFFFL);
        this._queueCache.setModifiedExpireTimeoutMillis(0x3FFFFFFFFFFFFFFFL);
        this._queueCache.init();
    }

    BrokerQueue addQueue(String name) {
        BrokerQueue queue = (BrokerQueue)this._queueCache.get(name);
        System.out.println("OLDQ: " + queue + " " + name);
        if (queue == null) {
            queue = new BrokerQueue(name, this._qidGen.incrementAndGet());
            this._queueCache.put(name, queue);
            queue = (BrokerQueue)this._queueCache.get(name);
            if (queue == null) {
                throw new NullPointerException();
            }
        }
        return queue;
    }

    public static class BrokerQueue
    implements Serializable {
        private String _name;
        private long _qid;

        public BrokerQueue() {
        }

        public BrokerQueue(String name, long qid) {
            this._name = name;
            this._qid = qid;
        }

        public String getName() {
            return this._name;
        }

        public long getId() {
            return this._qid;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + this._name + "," + Long.toHexString(this._qid) + "]";
        }
    }
}

