/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.message.stomp;

import com.caucho.message.stomp.StompClient;
import com.caucho.util.L10N;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StompClientSubscriber {
    private static final L10N L = new L10N(StompClientSubscriber.class);
    private static final Logger log = Logger.getLogger(StompClientSubscriber.class.getName());
    private StompClient _client;
    private String _id;
    private ArrayList<Msg> _queue = new ArrayList();
    private boolean _isClosed;

    StompClientSubscriber(StompClient client, String id) {
        this._client = client;
        this._id = id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String receive() {
        ArrayList<Msg> arrayList = this._queue;
        synchronized (arrayList) {
            if (this._queue.size() == 0) {
                try {
                    this._queue.wait(1000L);
                }
                catch (Exception e) {
                    log.log(Level.FINER, e.toString(), e);
                }
            }
            if (this._queue.size() > 0) {
                Msg msg = this._queue.remove(0);
                return msg.getBody();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() {
        this._isClosed = true;
        ArrayList<Msg> arrayList = this._queue;
        synchronized (arrayList) {
            this._queue.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addMessage(HashMap<String, String> headers, String body) {
        String destination = headers.get("destination");
        long id = Long.parseLong(headers.get("message-id"));
        Msg msg = new Msg(id, destination, body);
        ArrayList<Msg> arrayList = this._queue;
        synchronized (arrayList) {
            this._queue.add(msg);
            this._queue.notifyAll();
        }
    }

    static class Msg {
        private long _id;
        private String _destination;
        private String _body;

        Msg(long id, String destination, String body) {
            this._id = id;
            this._destination = destination;
            this._body = body;
        }

        long getId() {
            return this._id;
        }

        String getBody() {
            return this._body;
        }
    }
}

