/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.message.tourmaline;

import com.caucho.message.DistributionMode;
import com.caucho.message.broker.BrokerReceiver;
import com.caucho.message.broker.MessageBroker;
import com.caucho.message.broker.ReceiverMessageHandler;
import com.caucho.message.tourmaline.NautilusCode;
import com.caucho.message.tourmaline.NautilusServerEndpoint;
import com.caucho.vfs.TempBuffer;
import com.caucho.websocket.WebSocketContext;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.logging.Logger;

class NautilusReceive
implements ReceiverMessageHandler {
    private static final Logger log = Logger.getLogger(NautilusReceive.class.getName());
    private NautilusServerEndpoint _endpoint;
    private MessageBroker _broker;
    private String _name;
    private BrokerReceiver _sub;
    private TempBuffer _tBuf = TempBuffer.allocate();
    private long _sequence;

    NautilusReceive(NautilusServerEndpoint endpoint) {
        this._endpoint = endpoint;
        this._broker = endpoint.getBroker();
    }

    void add(String key, String value) {
        if ("name".equals(key)) {
            this._name = value;
        }
    }

    void init() {
        if (this._name == null) {
            throw new IllegalStateException("'name' is required");
        }
        Map<String, Object> properties = null;
        this._sub = this._broker.createReceiver(this._name, DistributionMode.MOVE, properties, this);
        System.out.println("SUB: " + this._sub);
        if (this._sub == null) {
            throw new IllegalStateException(this._name + " is an unknown queue");
        }
        this.flow(0L, 1);
    }

    public void flow(long count, int credit) {
        this._sub.flow(count, credit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(long messageId, InputStream is, long contentLength) throws IOException {
        WebSocketContext wsContext = this._endpoint.getContext();
        OutputStream os = wsContext.startBinaryMessage();
        System.out.println("ONMSG: " + messageId);
        try {
            int len;
            os.write(NautilusCode.SEND.ordinal());
            byte[] buffer = this._tBuf.getBuffer();
            while ((len = is.read(buffer, 0, buffer.length)) > 0) {
                os.write(buffer, 0, len);
            }
            Object var11_8 = null;
        }
        catch (Throwable throwable) {
            Object var11_9 = null;
            os.close();
            throw throwable;
        }
        os.close();
    }

    public void close() {
        this._sub.close();
    }
}

