/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.network.listen;

import com.caucho.inject.Module;
import java.util.concurrent.atomic.AtomicReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Module
enum SocketLinkRequestState {
    INIT{

        @Override
        public boolean isAllowIdle() {
            return true;
        }

        @Override
        boolean toAccept(AtomicReference<SocketLinkRequestState> stateRef) {
            if (!stateRef.compareAndSet(INIT, REQUEST)) {
                throw new IllegalStateException((Object)((Object)this) + " to " + (Object)((Object)stateRef.get()));
            }
            return true;
        }
    }
    ,
    REQUEST{

        @Override
        public boolean isAllowIdle() {
            return true;
        }

        @Override
        boolean toIdle(AtomicReference<SocketLinkRequestState> stateRef) {
            if (!stateRef.compareAndSet(REQUEST, INIT)) {
                throw new IllegalStateException((Object)((Object)this) + " to " + (Object)((Object)stateRef.get()));
            }
            return true;
        }

        @Override
        boolean toStartKeepalive(AtomicReference<SocketLinkRequestState> stateRef) {
            if (!stateRef.compareAndSet(REQUEST, KEEPALIVE_START)) {
                throw new IllegalStateException((Object)((Object)this) + " to " + (Object)((Object)stateRef.get()));
            }
            return true;
        }

        @Override
        boolean toAsyncStart(AtomicReference<SocketLinkRequestState> stateRef) {
            if (!stateRef.compareAndSet(REQUEST, ASYNC_START)) {
                throw new IllegalStateException((Object)((Object)this) + " to " + (Object)((Object)stateRef.get()));
            }
            return true;
        }

        @Override
        boolean toAsyncWake(AtomicReference<SocketLinkRequestState> stateRef) {
            return false;
        }
    }
    ,
    KEEPALIVE_START{

        @Override
        boolean toWakeKeepalive(AtomicReference<SocketLinkRequestState> stateRef) {
            SocketLinkRequestState state;
            do {
                if (stateRef.compareAndSet(KEEPALIVE_SUSPEND, REQUEST)) {
                    return true;
                }
                if (!stateRef.compareAndSet(KEEPALIVE_START, KEEPALIVE_WAKE)) continue;
                return false;
            } while ((state = stateRef.get()) == KEEPALIVE_SUSPEND || state == KEEPALIVE_START);
            throw new IllegalStateException((Object)((Object)this) + " to " + (Object)((Object)stateRef.get()));
        }

        @Override
        boolean toSuspendKeepalive(AtomicReference<SocketLinkRequestState> stateRef) {
            SocketLinkRequestState state;
            do {
                if (stateRef.compareAndSet(KEEPALIVE_START, KEEPALIVE_SUSPEND)) {
                    return true;
                }
                if (!stateRef.compareAndSet(KEEPALIVE_WAKE, REQUEST)) continue;
                return false;
            } while ((state = stateRef.get()) == KEEPALIVE_START || state == KEEPALIVE_WAKE);
            throw new IllegalStateException((Object)((Object)this) + " to " + (Object)((Object)stateRef.get()));
        }

        @Override
        boolean toDestroy(AtomicReference<SocketLinkRequestState> stateRef) {
            if (stateRef.compareAndSet(this, DESTROY)) {
                return true;
            }
            return stateRef.get().toDestroy(stateRef);
        }
    }
    ,
    KEEPALIVE_WAKE{

        @Override
        boolean toSuspendKeepalive(AtomicReference<SocketLinkRequestState> stateRef) {
            if (stateRef.compareAndSet(KEEPALIVE_WAKE, REQUEST)) {
                return false;
            }
            throw new IllegalStateException((Object)((Object)this) + " to " + (Object)((Object)stateRef.get()));
        }

        @Override
        boolean toDestroy(AtomicReference<SocketLinkRequestState> stateRef) {
            if (stateRef.compareAndSet(this, DESTROY)) {
                return true;
            }
            return stateRef.get().toDestroy(stateRef);
        }
    }
    ,
    KEEPALIVE_SUSPEND{

        @Override
        boolean toWakeKeepalive(AtomicReference<SocketLinkRequestState> stateRef) {
            if (stateRef.compareAndSet(KEEPALIVE_SUSPEND, REQUEST)) {
                return true;
            }
            throw new IllegalStateException((Object)((Object)this) + " to " + (Object)((Object)stateRef.get()));
        }

        @Override
        boolean toDestroy(AtomicReference<SocketLinkRequestState> stateRef) {
            if (stateRef.compareAndSet(this, DESTROY)) {
                return true;
            }
            return stateRef.get().toDestroy(stateRef);
        }
    }
    ,
    ASYNC_START{

        @Override
        public boolean isAsyncStarted() {
            return true;
        }

        @Override
        boolean toAsyncSuspend(AtomicReference<SocketLinkRequestState> stateRef) {
            if (stateRef.compareAndSet(ASYNC_START, SUSPEND)) {
                return true;
            }
            if (stateRef.compareAndSet(ASYNC_WAKE, REQUEST)) {
                return false;
            }
            throw new IllegalStateException((Object)((Object)this) + " to " + (Object)((Object)stateRef.get()));
        }

        @Override
        boolean toAsyncResume(AtomicReference<SocketLinkRequestState> stateRef) {
            return stateRef.compareAndSet(ASYNC_WAKE, REQUEST);
        }

        @Override
        boolean toAsyncWake(AtomicReference<SocketLinkRequestState> stateRef) {
            if (stateRef.compareAndSet(ASYNC_START, ASYNC_WAKE)) {
                return false;
            }
            return stateRef.get().toAsyncWake(stateRef);
        }
    }
    ,
    ASYNC_WAKE{

        @Override
        public boolean isAsyncWake() {
            return true;
        }

        @Override
        boolean toAsyncSuspend(AtomicReference<SocketLinkRequestState> stateRef) {
            if (stateRef.compareAndSet(ASYNC_WAKE, REQUEST)) {
                return false;
            }
            throw new IllegalStateException((Object)((Object)this) + " to " + (Object)((Object)stateRef.get()));
        }

        @Override
        boolean toAsyncResume(AtomicReference<SocketLinkRequestState> stateRef) {
            return stateRef.compareAndSet(ASYNC_WAKE, REQUEST);
        }
    }
    ,
    SUSPEND{

        @Override
        public boolean isAsyncStarted() {
            return true;
        }

        @Override
        boolean toAsyncWake(AtomicReference<SocketLinkRequestState> stateRef) {
            if (!stateRef.compareAndSet(SUSPEND, REQUEST)) {
                throw new IllegalStateException((Object)((Object)this) + " to " + (Object)((Object)stateRef.get()));
            }
            return true;
        }

        @Override
        boolean toDestroy(AtomicReference<SocketLinkRequestState> stateRef) {
            if (stateRef.compareAndSet(this, DESTROY)) {
                return true;
            }
            return stateRef.get().toDestroy(stateRef);
        }
    }
    ,
    DESTROY{

        @Override
        public boolean isDestroyed() {
            return true;
        }

        @Override
        boolean toDestroy(AtomicReference<SocketLinkRequestState> stateRef) {
            return false;
        }
    };


    public boolean isAllowIdle() {
        return false;
    }

    public boolean isAsyncWake() {
        return false;
    }

    boolean toAccept(AtomicReference<SocketLinkRequestState> stateRef) {
        throw new IllegalStateException(this.toString());
    }

    boolean toStartKeepalive(AtomicReference<SocketLinkRequestState> stateRef) {
        throw new IllegalStateException(this.toString());
    }

    boolean toSuspendKeepalive(AtomicReference<SocketLinkRequestState> stateRef) {
        throw new IllegalStateException(this.toString());
    }

    boolean toWakeKeepalive(AtomicReference<SocketLinkRequestState> stateRef) {
        throw new IllegalStateException(this.toString());
    }

    boolean toAsyncStart(AtomicReference<SocketLinkRequestState> stateRef) {
        throw new IllegalStateException(this.toString());
    }

    boolean toAsyncSuspend(AtomicReference<SocketLinkRequestState> stateRef) {
        throw new IllegalStateException(this.toString());
    }

    boolean toAsyncResume(AtomicReference<SocketLinkRequestState> stateRef) {
        throw new IllegalStateException(this.toString());
    }

    boolean toAsyncWake(AtomicReference<SocketLinkRequestState> stateRef) {
        throw new IllegalStateException("async dispatch is not valid outside of an async cycle.  Current state: " + this.toString());
    }

    boolean toIdle(AtomicReference<SocketLinkRequestState> stateRef) {
        throw new IllegalStateException(this.toString());
    }

    boolean toDestroy(AtomicReference<SocketLinkRequestState> stateRef) {
        if (stateRef.compareAndSet(this, DESTROY)) {
            return false;
        }
        return stateRef.get().toDestroy(stateRef);
    }

    public boolean isDestroyed() {
        return false;
    }

    public boolean isAsyncStarted() {
        return false;
    }
}

