/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.network.listen;

import com.caucho.inject.Module;
import com.caucho.management.server.AbstractManagedObject;
import com.caucho.management.server.PortMXBean;
import com.caucho.management.server.TcpConnectionInfo;
import com.caucho.network.listen.TcpPort;

@Module
public class TcpPortAdmin
extends AbstractManagedObject
implements PortMXBean {
    private TcpPort _port;

    public TcpPortAdmin(TcpPort port) {
        this._port = port;
    }

    public String getName() {
        String addr = this._port.getAddress();
        if (addr == null) {
            addr = "INADDR_ANY";
        }
        return addr + '-' + this._port.getPort();
    }

    public String getProtocolName() {
        return this._port.getProtocolName();
    }

    public String getAddress() {
        return this._port.getAddress();
    }

    public int getPort() {
        return this._port.getPort();
    }

    public boolean isSSL() {
        return this._port.isSSL();
    }

    public int getAcceptThreadMin() {
        return this._port.getAcceptThreadMin();
    }

    public int getAcceptThreadMax() {
        return this._port.getAcceptThreadMax();
    }

    public int getAcceptListenBacklog() {
        return this._port.getAcceptListenBacklog();
    }

    public int getConnectionMax() {
        return this._port.getConnectionMax();
    }

    public int getPortThreadMax() {
        return this._port.getPortThreadMax();
    }

    public int getKeepaliveMax() {
        return this._port.getKeepaliveMax();
    }

    public int getKeepaliveSelectMax() {
        return this._port.getKeepaliveSelectMax();
    }

    public long getKeepaliveConnectionTimeMax() {
        return this._port.getKeepaliveConnectionTimeMax();
    }

    public long getKeepaliveThreadTimeout() {
        return this._port.getKeepaliveThreadTimeout();
    }

    public long getKeepaliveTimeout() {
        return this._port.getKeepaliveTimeout();
    }

    public long getSocketTimeout() {
        return this._port.getSocketTimeout();
    }

    public boolean isTcpKeepalive() {
        return this._port.isTcpKeepalive();
    }

    public boolean isTcpNoDelay() {
        return this._port.isTcpNoDelay();
    }

    public long getSuspendTimeMax() {
        return this._port.getSuspendTimeMax();
    }

    public String getState() {
        return this._port.getLifecycleState().getStateName();
    }

    public int getThreadCount() {
        return this._port.getThreadCount();
    }

    public int getThreadActiveCount() {
        return this._port.getActiveThreadCount();
    }

    public int getThreadIdleCount() {
        return this._port.getIdleThreadCount();
    }

    public int getThreadStartCount() {
        return this._port.getStartThreadCount();
    }

    public boolean isJniEnabled() {
        return this._port.isJniEnabled();
    }

    public int getKeepaliveCount() {
        return this._port.getKeepaliveConnectionCount();
    }

    public int getKeepaliveThreadCount() {
        return this._port.getKeepaliveThreadCount();
    }

    public int getKeepaliveSelectCount() {
        return this._port.getSelectConnectionCount();
    }

    public int getCometIdleCount() {
        return this._port.getCometIdleCount();
    }

    public long getRequestCountTotal() {
        return this._port.getLifetimeRequestCount();
    }

    public long getKeepaliveCountTotal() {
        return this._port.getLifetimeKeepaliveCount();
    }

    public long getKeepaliveSelectCountTotal() {
        return this._port.getLifetimeKeepaliveSelectCount();
    }

    public long getClientDisconnectCountTotal() {
        return this._port.getLifetimeClientDisconnectCount();
    }

    public long getThrottleDisconnectCountTotal() {
        return this._port.getLifetimeThrottleDisconnectCount();
    }

    public long getRequestTimeTotal() {
        return this._port.getLifetimeRequestTime();
    }

    public long getReadBytesTotal() {
        return this._port.getLifetimeReadBytes();
    }

    public long getWriteBytesTotal() {
        return this._port.getLifetimeWriteBytes();
    }

    public void start() {
        this._port.enable();
    }

    public void stop() {
        this._port.disable();
    }

    public TcpConnectionInfo[] connectionInfo() {
        return this._port.getActiveConnections();
    }

    void register() {
        this.registerSelf();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getObjectName() + "]";
    }
}

