/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.network.proxy;

public class ProxyResult {
    private ProxyStatus _status = ProxyStatus.FAIL;
    private boolean _keepAlive = false;
    private String _failureMessage;

    public ProxyResult(ProxyStatus status, boolean keepAlive) {
        this._status = status;
        this._keepAlive = keepAlive;
    }

    public ProxyResult(ProxyStatus status, boolean keepAlive, String failureMessage) {
        this._status = status;
        this._keepAlive = keepAlive;
        this._failureMessage = failureMessage;
    }

    public boolean isSuccess() {
        return this._status == ProxyStatus.OK;
    }

    public ProxyStatus getStatus() {
        return this._status;
    }

    public void setStatus(ProxyStatus status) {
        this._status = status;
    }

    public boolean isKeepAlive() {
        return this._keepAlive;
    }

    public void setKeepAlive(boolean keepAlive) {
        this._keepAlive = keepAlive;
    }

    public String getFailureMessage() {
        if (this._failureMessage == null && this._status == ProxyStatus.BUSY) {
            return "busy";
        }
        return this._failureMessage;
    }

    public void setFailureMessage(String failureMessage) {
        this._failureMessage = failureMessage;
    }

    public String toString() {
        return String.format("%s[status=%s,keepAlive=%s%s]", new Object[]{this.getClass().getSimpleName(), this._status, this._keepAlive, this._failureMessage != null ? "," + this._failureMessage : ""});
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ProxyStatus {
        OK,
        BUSY,
        FAIL;

    }
}

