/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus;

public class Location {
    public static final Location UNKNOWN = new Location();
    private final String _fileName;
    private final String _userPath;
    private final int _lineNumber;
    private final String _className;
    private final String _functionName;

    public Location(String fileName, int lineNumber, String className, String functionName) {
        this._fileName = fileName;
        this._userPath = fileName;
        this._lineNumber = lineNumber;
        this._className = className;
        this._functionName = functionName;
    }

    public Location(String fileName, String userPath, int lineNumber, String className, String functionName) {
        this._fileName = fileName;
        this._userPath = userPath;
        this._lineNumber = lineNumber;
        this._className = className;
        this._functionName = functionName;
    }

    private Location() {
        this._fileName = null;
        this._userPath = null;
        this._lineNumber = 0;
        this._className = null;
        this._functionName = null;
    }

    public String getFileName() {
        return this._fileName;
    }

    public String getUserPath() {
        return this._userPath;
    }

    public int getLineNumber() {
        return this._lineNumber;
    }

    public String getClassName() {
        return this._className;
    }

    public String getFunctionName() {
        return this._functionName;
    }

    public String getMessagePrefix() {
        if (this._fileName == null) {
            return "";
        }
        return this._fileName + ":" + this._lineNumber + ": ";
    }

    public boolean isUnknown() {
        return this._fileName == null || this._lineNumber <= 0;
    }

    public String toString() {
        return "Location[" + this._fileName + ":" + this._lineNumber + "]";
    }
}

