/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.env;

import com.caucho.quercus.env.Callback;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.QuercusClass;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.function.AbstractFunction;
import com.caucho.quercus.program.Arg;
import com.caucho.util.L10N;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.util.IdentityHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CallbackClassMethod
extends Callback {
    private static final L10N L = new L10N(CallbackClassMethod.class);
    private final QuercusClass _qClass;
    private final StringValue _methodName;
    private final int _hash;
    private final Value _qThis;

    public CallbackClassMethod(QuercusClass qClass, StringValue methodName, Value qThis) {
        this._qClass = qClass;
        this._methodName = methodName;
        this._hash = methodName.hashCodeCaseInsensitive();
        this._qThis = qThis;
    }

    public CallbackClassMethod(QuercusClass qClass, StringValue methodName) {
        this(qClass, methodName, qClass);
    }

    @Override
    public Value call(Env env) {
        return this._qClass.callMethod(env, this._qThis, this._methodName, this._hash);
    }

    @Override
    public Value call(Env env, Value a1) {
        return this._qClass.callMethod(env, this._qThis, this._methodName, this._hash, a1);
    }

    @Override
    public Value call(Env env, Value a1, Value a2) {
        return this._qClass.callMethod(env, this._qThis, this._methodName, this._hash, a1, a2);
    }

    @Override
    public Value call(Env env, Value a1, Value a2, Value a3) {
        return this._qClass.callMethod(env, this._qThis, this._methodName, this._hash, a1, a2, a3);
    }

    @Override
    public Value call(Env env, Value a1, Value a2, Value a3, Value a4) {
        return this._qClass.callMethod(env, this._qThis, this._methodName, this._hash, a1, a2, a3, a4);
    }

    @Override
    public Value call(Env env, Value a1, Value a2, Value a3, Value a4, Value a5) {
        return this._qClass.callMethod(env, this._qThis, this._methodName, this._hash, a1, a2, a3, a4, a5);
    }

    @Override
    public Value call(Env env, Value[] args) {
        return this._qClass.callMethod(env, this._qThis, this._methodName, this._hash, args);
    }

    @Override
    public void varDumpImpl(Env env, WriteStream out, int depth, IdentityHashMap<Value, String> valueSet) throws IOException {
        out.print(this.getClass().getName());
        out.print('[');
        out.print(this._qClass.getName());
        out.print(", ");
        out.print(this._methodName);
        out.print(']');
    }

    @Override
    public boolean isValid(Env env) {
        return true;
    }

    @Override
    public String getCallbackName() {
        return this._qClass.getName() + "::" + this._methodName.toString();
    }

    @Override
    public String getDeclFileName(Env env) {
        return this.getMethod().getDeclFileName(env);
    }

    @Override
    public int getDeclStartLine(Env env) {
        return this.getMethod().getDeclStartLine(env);
    }

    @Override
    public int getDeclEndLine(Env env) {
        return this.getMethod().getDeclEndLine(env);
    }

    @Override
    public String getDeclComment(Env env) {
        return this.getMethod().getDeclComment(env);
    }

    @Override
    public boolean isReturnsReference(Env env) {
        return this.getMethod().isReturnsReference(env);
    }

    @Override
    public Arg[] getArgs(Env env) {
        return this.getMethod().getArgs(env);
    }

    private AbstractFunction getMethod() {
        return this._qClass.getFunction(this._methodName);
    }

    @Override
    public boolean isInternal(Env env) {
        return false;
    }

    private Value error(Env env) {
        env.warning(L.l("{0}::{1}() is an invalid callback method", (Object)this._qClass.getName(), (Object)this._methodName));
        return NullValue.NULL;
    }
}

